/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.schema;

import com.alibaba.lindorm.client.core.meta.TableType;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.schema.DescriptorAttributes;
import com.alibaba.lindorm.client.schema.IndexState;
import com.alibaba.lindorm.client.schema.IndexedColumnSchema;
import com.alibaba.lindorm.client.schema.Mutability;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class LindormSecondaryIndexDescriptor
extends DescriptorAttributes {
    public static final ColumnKey COVERED_ALL_COLUMNS_IN_SCHEMA = new ColumnKey("ALL");
    public static final ColumnKey COVERED_DYNAMIC_COLUMNS = new ColumnKey("DYNAMIC");
    private String indexName;
    private String dataTableName;
    private TableType type;
    private List<IndexedColumnSchema> indexedColumns = CollectionUtils.newArrayList();
    private List<ColumnKey> coveredColumns = CollectionUtils.newArrayList();
    private IndexState indexState;
    private boolean storeFamilyNameInQualifier = false;
    private int metaVersion;
    private Condition indexCondition;
    private boolean storePkNulls = true;
    private boolean localIndex;
    private boolean storePkTS;
    private boolean skipCheckMeaninglessIndex = false;

    public LindormSecondaryIndexDescriptor() {
    }

    public LindormSecondaryIndexDescriptor(String indexName, String dataTableName) {
        this.indexName = indexName;
        this.dataTableName = dataTableName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getDataTableName() {
        return this.dataTableName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setDataTableName(String dataTableName) {
        this.dataTableName = dataTableName;
    }

    public void setTableType(TableType type) {
        this.type = type;
    }

    public TableType getTableType() {
        return this.type;
    }

    public boolean isLocalIndex() {
        return this.localIndex;
    }

    public void setLocalIndex() {
        this.localIndex = true;
    }

    public void addIndexedColumns(IndexedColumnSchema column) {
        if (this.indexedColumns == null) {
            this.indexedColumns = CollectionUtils.newArrayList();
        }
        this.indexedColumns.add(column);
    }

    public void setIndexedColumns(List<IndexedColumnSchema> indexedColumns) {
        this.indexedColumns = indexedColumns;
    }

    public List<IndexedColumnSchema> getIndexedColumns() {
        return this.indexedColumns;
    }

    public void addCoveredColumn(ColumnKey columnKey) {
        if (this.coveredColumns == null) {
            this.coveredColumns = CollectionUtils.newArrayList();
        }
        this.coveredColumns.add(columnKey);
    }

    public void setCoveredColumns(List<ColumnKey> coveredColumns) {
        this.coveredColumns = coveredColumns;
    }

    public List<ColumnKey> getCoveredColumns() {
        return this.coveredColumns;
    }

    public void setIndexState(IndexState indexState) {
        this.indexState = indexState;
    }

    public IndexState getIndexState() {
        return this.indexState;
    }

    public int getMetaVersion() {
        return this.metaVersion;
    }

    public void setMetaVersion(int metaVersion) {
        this.metaVersion = metaVersion;
    }

    @Override
    public void setMutability(Mutability mutability) {
        throw new UnsupportedOperationException("Index descriptor does not support mutability");
    }

    @Override
    public void setUsingHashEngine(boolean enableHash) {
        throw new UnsupportedOperationException("Index descriptor does not support hash engine");
    }

    @Override
    public DescriptorAttributes setTimeToLive(int ttl, TimeUnit unit) {
        throw new UnsupportedOperationException("Index descriptor does not support time to live");
    }

    @Override
    public DescriptorAttributes setMaxVersions(int maxVersions) {
        throw new UnsupportedOperationException("Index descriptor does not support max version");
    }

    @Override
    public DescriptorAttributes setMinVersions(int minVersions) {
        throw new UnsupportedOperationException("Index descriptor does not support min version");
    }

    @Override
    public DescriptorAttributes setTimeToPurgeDeletes(long timeToPurgeDelete, TimeUnit unit) {
        throw new UnsupportedOperationException("Index descriptor does not support time to purge deletes");
    }

    @Override
    public void setFamilyAttributes(byte[] familyName, String name, String value) throws IllegalRequestException {
        throw new UnsupportedOperationException("Index descriptor does not support set family level attributes");
    }

    public void where(Condition indexCondition) {
        this.indexCondition = indexCondition;
    }

    public Condition getIndexCondition() {
        return this.indexCondition;
    }

    public boolean isStorePkNulls() {
        return this.storePkNulls;
    }

    public void setStorePkNulls(boolean storePkNulls) {
        this.storePkNulls = storePkNulls;
    }

    public boolean isStorePkTS() {
        return this.storePkTS;
    }

    public void setStorePkTS(boolean storePkTS) {
        this.storePkTS = storePkTS;
    }

    public boolean isStoreFamilyNameInQualifier() {
        return this.storeFamilyNameInQualifier;
    }

    public void setStoreFamilyNameInQualifier(boolean storeFamilyNameInQualifier) {
        this.storeFamilyNameInQualifier = storeFamilyNameInQualifier;
    }

    public IndexedColumnSchema getFirstIndexedColumn() {
        return this.indexedColumns.get(0);
    }

    public boolean isSkipCheckMeaninglessIndex() {
        return this.skipCheckMeaninglessIndex;
    }

    public void setSkipCheckMeaninglessIndex(boolean skipCheck) {
        this.skipCheckMeaninglessIndex = skipCheck;
    }

    public boolean getSkipCheckMeaninglessIndex() {
        return this.skipCheckMeaninglessIndex;
    }

    public String getSchema() {
        StringBuilder str = new StringBuilder();
        str.append("Secondary Index [");
        str.append(this.indexName);
        str.append("] on [");
        str.append(this.dataTableName);
        str.append("] (");
        if (this.indexedColumns != null && this.indexedColumns.size() > 0) {
            for (IndexedColumnSchema ic : this.indexedColumns) {
                str.append(ic.toString());
                str.append(",");
            }
            str.setLength(str.length() - 1);
        }
        str.append(")");
        if (this.coveredColumns != null && this.coveredColumns.size() > 0) {
            str.append(" includes (");
            for (ColumnKey key : this.coveredColumns) {
                str.append(key);
                str.append(",");
            }
            str.setLength(str.length() - 1);
            str.append(")");
        }
        if (this.indexCondition != null) {
            str.append(" where (");
            str.append(this.indexCondition);
            str.append(")");
        }
        if (null != this.indexState) {
            str.append(" index state (");
            str.append((Object)this.indexState);
            str.append(")");
        }
        str.append(", MetaVerion: ");
        str.append(this.metaVersion);
        str.append(", storePkNulls (");
        str.append(this.storePkNulls);
        str.append(")");
        str.append(", storePkTS (");
        str.append(this.storePkTS);
        str.append(")");
        str.append(", skipCheckMeaninglessIndex (");
        str.append(this.skipCheckMeaninglessIndex);
        str.append(")");
        str.append(", includeFamilyInQualifier (");
        str.append(this.storeFamilyNameInQualifier);
        str.append(")");
        if (this.type != null) {
            str.append(", table type: ");
            str.append(this.type.name());
        }
        return str.toString();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getSchema());
        str.append(", TABLE_ATTR: ");
        str.append(this.tableAttributes.toString());
        str.append(", FAMILY_ATTR: ");
        str.append(this.familyAttributes.toString());
        return str.toString();
    }

    public boolean equals(Object obj) {
        return false;
    }
}

