/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.impl;

import com.alibaba.nacos.client.config.utils.ConcurrentDiskUtil;
import com.alibaba.nacos.client.config.utils.IOUtils;
import com.alibaba.nacos.client.config.utils.JVMUtil;
import com.alibaba.nacos.client.config.utils.LogUtils;
import com.alibaba.nacos.client.config.utils.SnapShotSwitch;
import com.alibaba.nacos.client.logger.Logger;
import com.alibaba.nacos.client.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LocalConfigInfoProcessor {
    public static final Logger log = LogUtils.logger(LocalConfigInfoProcessor.class);
    public static final String LOCAL_FILEROOT_PATH = System.getProperty("JM.LOG.PATH", System.getProperty("user.home")) + File.separator + "nacos" + File.separator + "config";
    public static final String LOCAL_SNAPSHOT_PATH = System.getProperty("JM.SNAPSHOT.PATH", System.getProperty("user.home")) + File.separator + "nacos" + File.separator + "config";

    public static String getFailover(String serverName, String dataId, String group, String tenant) {
        File localPath = LocalConfigInfoProcessor.getFailoverFile(serverName, dataId, group, tenant);
        if (!localPath.exists() || !localPath.isFile()) {
            return null;
        }
        try {
            return LocalConfigInfoProcessor.readFile(localPath);
        }
        catch (IOException ioe) {
            log.error(serverName, "NACOS-XXXX", "get failover error, " + localPath + ioe.toString());
            return null;
        }
    }

    public static String getSnapshot(String name, String dataId, String group, String tenant) {
        if (!SnapShotSwitch.getIsSnapShot().booleanValue()) {
            return null;
        }
        File file = LocalConfigInfoProcessor.getSnapshotFile(name, dataId, group, tenant);
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        try {
            return LocalConfigInfoProcessor.readFile(file);
        }
        catch (IOException ioe) {
            log.error(name, "NACOS-XXXX", "get snapshot error, " + file + ", " + ioe.toString());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(File file) throws IOException {
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        if (JVMUtil.isMultiInstance().booleanValue()) {
            return ConcurrentDiskUtil.getFileContent(file, "UTF-8");
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            String string = IOUtils.toString(is, "UTF-8");
            return string;
        }
        finally {
            try {
                if (null != is) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void saveSnapshot(String envName, String dataId, String group, String tenant, String config) {
        if (!SnapShotSwitch.getIsSnapShot().booleanValue()) {
            return;
        }
        File file = LocalConfigInfoProcessor.getSnapshotFile(envName, dataId, group, tenant);
        if (null == config) {
            try {
                IOUtils.delete(file);
            }
            catch (IOException ioe) {
                log.error(envName, "NACOS-XXXX", "delete snapshot error, " + file + ", " + ioe.toString());
            }
        } else {
            try {
                boolean isMdOk = file.getParentFile().mkdirs();
                if (!isMdOk) {
                    log.error(envName, "NACOS-XXXX", "save snapshot error");
                }
                if (JVMUtil.isMultiInstance().booleanValue()) {
                    ConcurrentDiskUtil.writeFileContent(file, config, "UTF-8");
                } else {
                    IOUtils.writeStringToFile(file, config, "UTF-8");
                }
            }
            catch (IOException ioe) {
                log.error(envName, "NACOS-XXXX", "save snapshot error, " + file + ", " + ioe.toString());
            }
        }
    }

    public static void cleanAllSnapshot() {
        try {
            File rootFile = new File(LOCAL_SNAPSHOT_PATH);
            File[] files = rootFile.listFiles();
            if (files == null || files.length == 0) {
                return;
            }
            for (File file : files) {
                if (!file.getName().endsWith("_nacos")) continue;
                IOUtils.cleanDirectory(file);
            }
        }
        catch (IOException ioe) {
            log.error("NACOS-XXXX", "clean all snapshot error, " + ioe.toString(), ioe);
        }
    }

    public static void cleanEnvSnapshot(String envName) {
        File tmp = new File(LOCAL_SNAPSHOT_PATH, envName + "_nacos");
        tmp = new File(tmp, "snapshot");
        try {
            IOUtils.cleanDirectory(tmp);
            log.info("success dlelet " + envName + "-snapshot");
        }
        catch (IOException e) {
            log.info("fail dlelet " + envName + "-snapshot, " + e.toString());
            e.printStackTrace();
        }
    }

    static File getFailoverFile(String serverName, String dataId, String group, String tenant) {
        File tmp = new File(LOCAL_SNAPSHOT_PATH, serverName + "_nacos");
        tmp = new File(tmp, "data");
        if (StringUtils.isBlank(tenant)) {
            tmp = new File(tmp, "config-data");
        } else {
            tmp = new File(tmp, "config-data-tenant");
            tmp = new File(tmp, tenant);
        }
        return new File(new File(tmp, group), dataId);
    }

    static File getSnapshotFile(String envName, String dataId, String group, String tenant) {
        File tmp = new File(LOCAL_SNAPSHOT_PATH, envName + "_nacos");
        if (StringUtils.isBlank(tenant)) {
            tmp = new File(tmp, "snapshot");
        } else {
            tmp = new File(tmp, "snapshot-tenant");
            tmp = new File(tmp, tenant);
        }
        return new File(new File(tmp, group), dataId);
    }

    static {
        log.warn("LOCAL_SNAPSHOT_PATH:{}", LOCAL_SNAPSHOT_PATH);
    }
}

