/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.impl;

import com.alibaba.nacos.client.config.impl.Limiter;
import com.alibaba.nacos.client.utils.ParamUtil;
import com.alibaba.nacos.common.utils.IoUtils;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.UuidUtils;
import com.alibaba.nacos.common.utils.VersionUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HttpSimpleClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult httpGet(String url, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs, boolean isSSL) throws IOException {
        HttpResult httpResult;
        String encodedContent = HttpSimpleClient.encodingParams(paramValues, encoding);
        if (Limiter.isLimit(MD5Utils.md5Hex((String)((url = url + (null == encodedContent ? "" : "?" + encodedContent)) + encodedContent), (String)"UTF-8"))) {
            return new HttpResult(-503, "More than client-side current limit threshold");
        }
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(ParamUtil.getConnectTimeout() > 100 ? ParamUtil.getConnectTimeout() : 100);
            conn.setReadTimeout((int)readTimeoutMs);
            List<String> newHeaders = HttpSimpleClient.getHeaders(url, headers, paramValues);
            HttpSimpleClient.setHeaders(conn, newHeaders, encoding);
            conn.connect();
            int respCode = conn.getResponseCode();
            String resp = null;
            resp = 200 == respCode ? IoUtils.toString((InputStream)conn.getInputStream(), (String)encoding) : IoUtils.toString((InputStream)conn.getErrorStream(), (String)encoding);
            httpResult = new HttpResult(respCode, conn.getHeaderFields(), resp);
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(conn);
            throw throwable;
        }
        IoUtils.closeQuietly((HttpURLConnection)conn);
        return httpResult;
    }

    public static HttpResult httpGet(String url, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        return HttpSimpleClient.httpGet(url, headers, paramValues, encoding, readTimeoutMs, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult httpPost(String url, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs, boolean isSSL) throws IOException {
        HttpResult httpResult;
        String encodedContent = HttpSimpleClient.encodingParams(paramValues, encoding);
        String string = encodedContent = null == encodedContent ? "" : encodedContent;
        if (Limiter.isLimit(MD5Utils.md5Hex((String)(url + encodedContent), (String)"UTF-8"))) {
            return new HttpResult(-503, "More than client-side current limit threshold");
        }
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setRequestMethod("POST");
            conn.setConnectTimeout(ParamUtil.getConnectTimeout() > 3000 ? ParamUtil.getConnectTimeout() : 3000);
            conn.setReadTimeout((int)readTimeoutMs);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            List<String> newHeaders = HttpSimpleClient.getHeaders(url, headers, paramValues);
            HttpSimpleClient.setHeaders(conn, newHeaders, encoding);
            conn.getOutputStream().write(encodedContent.getBytes(encoding));
            int respCode = conn.getResponseCode();
            String resp = null;
            resp = 200 == respCode ? IoUtils.toString((InputStream)conn.getInputStream(), (String)encoding) : IoUtils.toString((InputStream)conn.getErrorStream(), (String)encoding);
            httpResult = new HttpResult(respCode, conn.getHeaderFields(), resp);
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(conn);
            throw throwable;
        }
        IoUtils.closeQuietly((HttpURLConnection)conn);
        return httpResult;
    }

    public static HttpResult httpPost(String url, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        return HttpSimpleClient.httpPost(url, headers, paramValues, encoding, readTimeoutMs, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult httpDelete(String url, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs, boolean isSSL) throws IOException {
        HttpResult httpResult;
        String encodedContent = HttpSimpleClient.encodingParams(paramValues, encoding);
        if (Limiter.isLimit(MD5Utils.md5Hex((String)((url = url + (null == encodedContent ? "" : "?" + encodedContent)) + encodedContent), (String)"UTF-8"))) {
            return new HttpResult(-503, "More than client-side current limit threshold");
        }
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setRequestMethod("DELETE");
            conn.setConnectTimeout(ParamUtil.getConnectTimeout() > 100 ? ParamUtil.getConnectTimeout() : 100);
            conn.setReadTimeout((int)readTimeoutMs);
            List<String> newHeaders = HttpSimpleClient.getHeaders(url, headers, paramValues);
            HttpSimpleClient.setHeaders(conn, newHeaders, encoding);
            conn.connect();
            int respCode = conn.getResponseCode();
            String resp = null;
            resp = 200 == respCode ? IoUtils.toString((InputStream)conn.getInputStream(), (String)encoding) : IoUtils.toString((InputStream)conn.getErrorStream(), (String)encoding);
            httpResult = new HttpResult(respCode, conn.getHeaderFields(), resp);
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(conn);
            throw throwable;
        }
        IoUtils.closeQuietly((HttpURLConnection)conn);
        return httpResult;
    }

    public static HttpResult httpDelete(String url, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        return HttpSimpleClient.httpGet(url, headers, paramValues, encoding, readTimeoutMs, false);
    }

    private static void setHeaders(HttpURLConnection conn, List<String> headers, String encoding) {
        if (null != headers) {
            Iterator<String> iter = headers.iterator();
            while (iter.hasNext()) {
                conn.addRequestProperty(iter.next(), iter.next());
            }
        }
        conn.addRequestProperty("Client-Version", VersionUtils.VERSION);
        conn.addRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=" + encoding);
        String ts = String.valueOf(System.currentTimeMillis());
        String token = MD5Utils.md5Hex((String)(ts + ParamUtil.getAppKey()), (String)"UTF-8");
        conn.addRequestProperty("Client-AppName", ParamUtil.getAppName());
        conn.addRequestProperty("Client-RequestTS", ts);
        conn.addRequestProperty("Client-RequestToken", token);
    }

    private static List<String> getHeaders(String url, List<String> headers, List<String> paramValues) throws IOException {
        ArrayList<String> newHeaders = new ArrayList<String>();
        newHeaders.add("exConfigInfo");
        newHeaders.add("true");
        newHeaders.add("RequestId");
        newHeaders.add(UuidUtils.generateUuid());
        if (headers != null) {
            newHeaders.addAll(headers);
        }
        return newHeaders;
    }

    private static String encodingParams(List<String> paramValues, String encoding) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        if (null == paramValues) {
            return null;
        }
        Iterator<String> iter = paramValues.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next()).append("=");
            sb.append(URLEncoder.encode(iter.next(), encoding));
            if (!iter.hasNext()) continue;
            sb.append("&");
        }
        return sb.toString();
    }

    public static class HttpResult {
        public final int code;
        public final Map<String, List<String>> headers;
        public final String content;

        public HttpResult(int code, String content) {
            this.code = code;
            this.headers = null;
            this.content = content;
        }

        public HttpResult(int code, Map<String, List<String>> headers, String content) {
            this.code = code;
            this.headers = headers;
            this.content = content;
        }

        public String toString() {
            return "HttpResult{code=" + this.code + ", headers=" + this.headers + ", content='" + this.content + '\'' + '}';
        }
    }
}

