/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.remote.gprc;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.client.naming.remote.gprc.NamingGrpcClientProxy;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.remote.client.ConnectionEventListener;
import com.alibaba.nacos.common.utils.ConcurrentHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class NamingGrpcConnectionEventListener
implements ConnectionEventListener {
    private final NamingGrpcClientProxy clientProxy;
    private final ConcurrentMap<String, Instance> registeredInstanceCached = new ConcurrentHashMap<String, Instance>();
    private final Set<String> subscribes = new ConcurrentHashSet<String>();

    public NamingGrpcConnectionEventListener(NamingGrpcClientProxy clientProxy) {
        this.clientProxy = clientProxy;
    }

    @Override
    public void onConnected() {
        this.redoSubscribe();
        this.redoRegisterEachService();
    }

    private void redoSubscribe() {
        LogUtils.NAMING_LOGGER.info("Grpc re-connect, redo subscribe services");
        for (String each : this.subscribes) {
            ServiceInfo serviceInfo = ServiceInfo.fromKey(each);
            try {
                this.clientProxy.subscribe(serviceInfo.getName(), serviceInfo.getGroupName(), serviceInfo.getClusters());
            }
            catch (NacosException e) {
                LogUtils.NAMING_LOGGER.warn(String.format("re subscribe service %s failed", serviceInfo.getName()), (Throwable)e);
            }
        }
    }

    private void redoRegisterEachService() {
        LogUtils.NAMING_LOGGER.info("Grpc re-connect, redo register services");
        for (Map.Entry each : this.registeredInstanceCached.entrySet()) {
            String serviceName = NamingUtils.getServiceName((String)each.getKey());
            String groupName = NamingUtils.getGroupName((String)each.getKey());
            this.redoRegisterEachInstance(serviceName, groupName, (Instance)each.getValue());
        }
    }

    private void redoRegisterEachInstance(String serviceName, String groupName, Instance instance) {
        try {
            this.clientProxy.registerService(serviceName, groupName, instance);
        }
        catch (NacosException e) {
            LogUtils.NAMING_LOGGER.warn(String.format("redo register for service %s@@%s, %s failed", groupName, serviceName, instance.toString()), (Throwable)e);
        }
    }

    @Override
    public void onDisConnect() {
        LogUtils.NAMING_LOGGER.warn("Grpc connection disconnect");
    }

    public void cacheInstanceForRedo(String serviceName, String groupName, Instance instance) {
        String key = NamingUtils.getGroupedName(serviceName, groupName);
        this.registeredInstanceCached.put(key, instance);
    }

    public void removeInstanceForRedo(String serviceName, String groupName, Instance instance) {
        String key = NamingUtils.getGroupedName(serviceName, groupName);
        this.registeredInstanceCached.remove(key);
    }

    public void cacheSubscriberForRedo(String fullServiceName, String cluster) {
        this.subscribes.add(ServiceInfo.getKey(fullServiceName, cluster));
    }

    public void removeSubscriberForRedo(String fullServiceName, String cluster) {
        this.subscribes.remove(ServiceInfo.getKey(fullServiceName, cluster));
    }
}

