/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.shaded.io.grpc.internal;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class JsonUtil {
    @Nullable
    public static List<?> getList(Map<String, ?> obj, String key) {
        assert (key != null);
        if (!obj.containsKey(key)) {
            return null;
        }
        Object value = obj.get(key);
        if (!(value instanceof List)) {
            throw new ClassCastException(String.format("value '%s' for key '%s' in '%s' is not List", value, key, obj));
        }
        return (List)value;
    }

    @Nullable
    public static Map<String, ?> getObject(Map<String, ?> obj, String key) {
        assert (key != null);
        if (!obj.containsKey(key)) {
            return null;
        }
        Object value = obj.get(key);
        if (!(value instanceof Map)) {
            throw new ClassCastException(String.format("value '%s' for key '%s' in '%s' is not object", value, key, obj));
        }
        return (Map)value;
    }

    @Nullable
    public static Double getDouble(Map<String, ?> obj, String key) {
        assert (key != null);
        if (!obj.containsKey(key)) {
            return null;
        }
        Object value = obj.get(key);
        if (!(value instanceof Double)) {
            throw new ClassCastException(String.format("value '%s' for key '%s' in '%s' is not Double", value, key, obj));
        }
        return (Double)value;
    }

    @Nullable
    public static String getString(Map<String, ?> obj, String key) {
        assert (key != null);
        if (!obj.containsKey(key)) {
            return null;
        }
        Object value = obj.get(key);
        if (!(value instanceof String)) {
            throw new ClassCastException(String.format("value '%s' for key '%s' in '%s' is not String", value, key, obj));
        }
        return (String)value;
    }

    @Nullable
    public static Boolean getBoolean(Map<String, ?> obj, String key) {
        assert (key != null);
        if (!obj.containsKey(key)) {
            return null;
        }
        Object value = obj.get(key);
        if (!(value instanceof Boolean)) {
            throw new ClassCastException(String.format("value '%s' for key '%s' in '%s' is not Boolean", value, key, obj));
        }
        return (Boolean)value;
    }

    public static List<Map<String, ?>> checkObjectList(List<?> rawList) {
        for (int i = 0; i < rawList.size(); ++i) {
            if (rawList.get(i) instanceof Map) continue;
            throw new ClassCastException(String.format("value %s for idx %d in %s is not object", rawList.get(i), i, rawList));
        }
        return rawList;
    }

    public static List<String> checkStringList(List<?> rawList) {
        for (int i = 0; i < rawList.size(); ++i) {
            if (rawList.get(i) instanceof String) continue;
            throw new ClassCastException(String.format("value '%s' for idx %d in '%s' is not string", rawList.get(i), i, rawList));
        }
        return rawList;
    }
}

