/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.backups;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.client.naming.cache.ConcurrentDiskUtil;
import com.alibaba.nacos.client.naming.cache.DiskCache;
import com.alibaba.nacos.client.naming.cache.ServiceInfoHolder;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.common.utils.ThreadUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class FailoverReactor
implements Closeable {
    private static final String FAILOVER_DIR = "/failover";
    private static final String IS_FAILOVER_MODE = "1";
    private static final String NO_FAILOVER_MODE = "0";
    private static final String FAILOVER_MODE_PARAM = "failover-mode";
    private Map<String, ServiceInfo> serviceMap = new ConcurrentHashMap<String, ServiceInfo>();
    private final Map<String, String> switchParams = new ConcurrentHashMap<String, String>();
    private static final long DAY_PERIOD_MINUTES = 1440L;
    private final String failoverDir;
    private final ServiceInfoHolder serviceInfoHolder;
    private final ScheduledExecutorService executorService;

    public FailoverReactor(ServiceInfoHolder serviceInfoHolder, String cacheDir) {
        this.serviceInfoHolder = serviceInfoHolder;
        this.failoverDir = cacheDir + FAILOVER_DIR;
        this.executorService = new ScheduledThreadPoolExecutor(1, r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("com.alibaba.nacos.naming.failover");
            return thread;
        });
        this.init();
    }

    public void init() {
        this.executorService.scheduleWithFixedDelay(new SwitchRefresher(), 0L, 5000L, TimeUnit.MILLISECONDS);
        this.executorService.scheduleWithFixedDelay(new DiskFileWriter(), 30L, 1440L, TimeUnit.MINUTES);
        this.executorService.schedule(() -> {
            try {
                File cacheDir = new File(this.failoverDir);
                if (!cacheDir.exists() && !cacheDir.mkdirs()) {
                    throw new IllegalStateException("failed to create cache dir: " + this.failoverDir);
                }
                File[] files = cacheDir.listFiles();
                if (files == null || files.length <= 0) {
                    new DiskFileWriter().run();
                }
            }
            catch (Throwable e) {
                LogUtils.NAMING_LOGGER.error("[NA] failed to backup file on startup.", e);
            }
        }, 10000L, TimeUnit.MILLISECONDS);
    }

    public Date addDay(Date date, int num) {
        Calendar startDT = Calendar.getInstance();
        startDT.setTime(date);
        startDT.add(5, num);
        return startDT.getTime();
    }

    @Override
    public void shutdown() throws NacosException {
        String className = this.getClass().getName();
        LogUtils.NAMING_LOGGER.info("{} do shutdown begin", (Object)className);
        ThreadUtils.shutdownThreadPool(this.executorService, LogUtils.NAMING_LOGGER);
        LogUtils.NAMING_LOGGER.info("{} do shutdown stop", (Object)className);
    }

    public boolean isFailoverSwitch() {
        return Boolean.parseBoolean(this.switchParams.get(FAILOVER_MODE_PARAM));
    }

    public ServiceInfo getService(String key) {
        ServiceInfo serviceInfo = this.serviceMap.get(key);
        if (serviceInfo == null) {
            serviceInfo = new ServiceInfo();
            serviceInfo.setName(key);
        }
        return serviceInfo;
    }

    class DiskFileWriter
    extends TimerTask {
        DiskFileWriter() {
        }

        @Override
        public void run() {
            Map<String, ServiceInfo> map = FailoverReactor.this.serviceInfoHolder.getServiceInfoMap();
            for (Map.Entry<String, ServiceInfo> entry : map.entrySet()) {
                ServiceInfo serviceInfo = entry.getValue();
                if (StringUtils.equals(serviceInfo.getKey(), "000--00-ALL_IPS--00--000") || StringUtils.equals(serviceInfo.getName(), "envList") || StringUtils.equals(serviceInfo.getName(), "00-00---000-ENV_CONFIGS-000---00-00") || StringUtils.equals(serviceInfo.getName(), "vipclient.properties") || StringUtils.equals(serviceInfo.getName(), "00-00---000-ALL_HOSTS-000---00-00")) continue;
                DiskCache.write(serviceInfo, FailoverReactor.this.failoverDir);
            }
        }
    }

    class FailoverFileReader
    implements Runnable {
        FailoverFileReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashMap<String, ServiceInfo> domMap = new HashMap<String, ServiceInfo>(16);
            BufferedReader reader = null;
            try {
                File cacheDir = new File(FailoverReactor.this.failoverDir);
                if (!cacheDir.exists() && !cacheDir.mkdirs()) {
                    throw new IllegalStateException("failed to create cache dir: " + FailoverReactor.this.failoverDir);
                }
                File[] files = cacheDir.listFiles();
                if (files == null) {
                    return;
                }
                for (File file : files) {
                    if (!file.isFile() || file.getName().equals("00-00---000-VIPSRV_FAILOVER_SWITCH-000---00-00")) continue;
                    ServiceInfo dom = new ServiceInfo(file.getName());
                    try {
                        String dataString = ConcurrentDiskUtil.getFileContent(file, Charset.defaultCharset().toString());
                        reader = new BufferedReader(new StringReader(dataString));
                        String json = reader.readLine();
                        if (json != null) {
                            try {
                                dom = JacksonUtils.toObj(json, ServiceInfo.class);
                            }
                            catch (Exception e) {
                                LogUtils.NAMING_LOGGER.error("[NA] error while parsing cached dom : {}", (Object)json, (Object)e);
                            }
                        }
                    }
                    catch (Exception e) {
                        LogUtils.NAMING_LOGGER.error("[NA] failed to read cache for dom: {}", (Object)file.getName(), (Object)e);
                    }
                    finally {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (Exception exception) {}
                    }
                    if (CollectionUtils.isEmpty(dom.getHosts())) continue;
                    domMap.put(dom.getKey(), dom);
                }
            }
            catch (Exception e) {
                LogUtils.NAMING_LOGGER.error("[NA] failed to read cache file", (Throwable)e);
            }
            if (domMap.size() > 0) {
                FailoverReactor.this.serviceMap = domMap;
            }
        }
    }

    class SwitchRefresher
    implements Runnable {
        long lastModifiedMillis = 0L;

        SwitchRefresher() {
        }

        @Override
        public void run() {
            try {
                File switchFile = new File(FailoverReactor.this.failoverDir + "00-00---000-VIPSRV_FAILOVER_SWITCH-000---00-00");
                if (!switchFile.exists()) {
                    FailoverReactor.this.switchParams.put(FailoverReactor.FAILOVER_MODE_PARAM, Boolean.FALSE.toString());
                    LogUtils.NAMING_LOGGER.debug("failover switch is not found, {}", (Object)switchFile.getName());
                    return;
                }
                long modified = switchFile.lastModified();
                if (this.lastModifiedMillis < modified) {
                    this.lastModifiedMillis = modified;
                    String failover = ConcurrentDiskUtil.getFileContent(FailoverReactor.this.failoverDir + "00-00---000-VIPSRV_FAILOVER_SWITCH-000---00-00", Charset.defaultCharset().toString());
                    if (!StringUtils.isEmpty(failover)) {
                        String[] lines;
                        for (String line : lines = failover.split(DiskCache.getLineSeparator())) {
                            String line1 = line.trim();
                            if (FailoverReactor.IS_FAILOVER_MODE.equals(line1)) {
                                FailoverReactor.this.switchParams.put(FailoverReactor.FAILOVER_MODE_PARAM, Boolean.TRUE.toString());
                                LogUtils.NAMING_LOGGER.info("failover-mode is on");
                                new FailoverFileReader().run();
                                continue;
                            }
                            if (!FailoverReactor.NO_FAILOVER_MODE.equals(line1)) continue;
                            FailoverReactor.this.switchParams.put(FailoverReactor.FAILOVER_MODE_PARAM, Boolean.FALSE.toString());
                            LogUtils.NAMING_LOGGER.info("failover-mode is off");
                        }
                    } else {
                        FailoverReactor.this.switchParams.put(FailoverReactor.FAILOVER_MODE_PARAM, Boolean.FALSE.toString());
                    }
                }
            }
            catch (Throwable e) {
                LogUtils.NAMING_LOGGER.error("[NA] failed to read failover switch.", e);
            }
        }
    }
}

