/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.grpc.netty;

import com.alibaba.nacos.shaded.com.google.common.annotations.VisibleForTesting;
import com.alibaba.nacos.shaded.com.google.common.base.Preconditions;
import com.alibaba.nacos.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.alibaba.nacos.shaded.io.grpc.ExperimentalApi;
import com.alibaba.nacos.shaded.io.grpc.Internal;
import com.alibaba.nacos.shaded.io.grpc.ServerStreamTracer;
import com.alibaba.nacos.shaded.io.grpc.internal.AbstractServerImplBuilder;
import com.alibaba.nacos.shaded.io.grpc.internal.FixedObjectPool;
import com.alibaba.nacos.shaded.io.grpc.internal.GrpcUtil;
import com.alibaba.nacos.shaded.io.grpc.internal.KeepAliveManager;
import com.alibaba.nacos.shaded.io.grpc.internal.ObjectPool;
import com.alibaba.nacos.shaded.io.grpc.internal.SharedResourcePool;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.grpc.netty.NettyServer;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiator;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiators;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.grpc.netty.Utils;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelFactory;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelOption;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.channel.ReflectiveChannelFactory;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.channel.ServerChannel;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import java.io.File;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1784")
@CanIgnoreReturnValue
public final class NettyServerBuilder
extends AbstractServerImplBuilder<NettyServerBuilder> {
    public static final int DEFAULT_FLOW_CONTROL_WINDOW = 0x100000;
    static final long MAX_CONNECTION_IDLE_NANOS_DISABLED = Long.MAX_VALUE;
    static final long MAX_CONNECTION_AGE_NANOS_DISABLED = Long.MAX_VALUE;
    static final long MAX_CONNECTION_AGE_GRACE_NANOS_INFINITE = Long.MAX_VALUE;
    private static final long MIN_KEEPALIVE_TIME_NANO = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final long MIN_KEEPALIVE_TIMEOUT_NANO = TimeUnit.MICROSECONDS.toNanos(499L);
    private static final long MIN_MAX_CONNECTION_IDLE_NANO = TimeUnit.SECONDS.toNanos(1L);
    private static final long MIN_MAX_CONNECTION_AGE_NANO = TimeUnit.SECONDS.toNanos(1L);
    private static final long AS_LARGE_AS_INFINITE = TimeUnit.DAYS.toNanos(1000L);
    private static final ObjectPool<? extends EventLoopGroup> DEFAULT_BOSS_EVENT_LOOP_GROUP_POOL = SharedResourcePool.forResource(Utils.DEFAULT_BOSS_EVENT_LOOP_GROUP);
    private static final ObjectPool<? extends EventLoopGroup> DEFAULT_WORKER_EVENT_LOOP_GROUP_POOL = SharedResourcePool.forResource(Utils.DEFAULT_WORKER_EVENT_LOOP_GROUP);
    private final List<SocketAddress> listenAddresses = new ArrayList<SocketAddress>();
    private ChannelFactory<? extends ServerChannel> channelFactory = Utils.DEFAULT_SERVER_CHANNEL_FACTORY;
    private final Map<ChannelOption<?>, Object> channelOptions = new HashMap();
    private final Map<ChannelOption<?>, Object> childChannelOptions = new HashMap();
    private ObjectPool<? extends EventLoopGroup> bossEventLoopGroupPool = DEFAULT_BOSS_EVENT_LOOP_GROUP_POOL;
    private ObjectPool<? extends EventLoopGroup> workerEventLoopGroupPool = DEFAULT_WORKER_EVENT_LOOP_GROUP_POOL;
    private boolean forceHeapBuffer;
    private SslContext sslContext;
    private ProtocolNegotiator protocolNegotiator;
    private int maxConcurrentCallsPerConnection = Integer.MAX_VALUE;
    private boolean autoFlowControl = true;
    private int flowControlWindow = 0x100000;
    private int maxMessageSize = 0x400000;
    private int maxHeaderListSize = 8192;
    private long keepAliveTimeInNanos = GrpcUtil.DEFAULT_SERVER_KEEPALIVE_TIME_NANOS;
    private long keepAliveTimeoutInNanos = GrpcUtil.DEFAULT_SERVER_KEEPALIVE_TIMEOUT_NANOS;
    private long maxConnectionIdleInNanos = Long.MAX_VALUE;
    private long maxConnectionAgeInNanos = Long.MAX_VALUE;
    private long maxConnectionAgeGraceInNanos = Long.MAX_VALUE;
    private boolean permitKeepAliveWithoutCalls;
    private long permitKeepAliveTimeInNanos = TimeUnit.MINUTES.toNanos(5L);

    @CheckReturnValue
    public static NettyServerBuilder forPort(int port) {
        return new NettyServerBuilder(port);
    }

    @CheckReturnValue
    public static NettyServerBuilder forAddress(SocketAddress address) {
        return new NettyServerBuilder(address);
    }

    @CheckReturnValue
    private NettyServerBuilder(int port) {
        this.listenAddresses.add(new InetSocketAddress(port));
    }

    @CheckReturnValue
    private NettyServerBuilder(SocketAddress address) {
        this.listenAddresses.add(address);
    }

    public NettyServerBuilder addListenAddress(SocketAddress listenAddress) {
        this.listenAddresses.add(Preconditions.checkNotNull(listenAddress, "listenAddress"));
        return this;
    }

    public NettyServerBuilder channelType(Class<? extends ServerChannel> channelType) {
        Preconditions.checkNotNull(channelType, "channelType");
        return this.channelFactory(new ReflectiveChannelFactory<ServerChannel>(channelType));
    }

    public NettyServerBuilder channelFactory(ChannelFactory<? extends ServerChannel> channelFactory) {
        this.channelFactory = Preconditions.checkNotNull(channelFactory, "channelFactory");
        return this;
    }

    public <T> NettyServerBuilder withOption(ChannelOption<T> option, T value) {
        this.channelOptions.put(option, value);
        return this;
    }

    public <T> NettyServerBuilder withChildOption(ChannelOption<T> option, T value) {
        this.childChannelOptions.put(option, value);
        return this;
    }

    public NettyServerBuilder bossEventLoopGroup(EventLoopGroup group) {
        if (group != null) {
            return this.bossEventLoopGroupPool(new FixedObjectPool<EventLoopGroup>(group));
        }
        return this.bossEventLoopGroupPool(DEFAULT_BOSS_EVENT_LOOP_GROUP_POOL);
    }

    NettyServerBuilder bossEventLoopGroupPool(ObjectPool<? extends EventLoopGroup> bossEventLoopGroupPool) {
        this.bossEventLoopGroupPool = Preconditions.checkNotNull(bossEventLoopGroupPool, "bossEventLoopGroupPool");
        return this;
    }

    public NettyServerBuilder workerEventLoopGroup(EventLoopGroup group) {
        if (group != null) {
            return this.workerEventLoopGroupPool(new FixedObjectPool<EventLoopGroup>(group));
        }
        return this.workerEventLoopGroupPool(DEFAULT_WORKER_EVENT_LOOP_GROUP_POOL);
    }

    NettyServerBuilder workerEventLoopGroupPool(ObjectPool<? extends EventLoopGroup> workerEventLoopGroupPool) {
        this.workerEventLoopGroupPool = Preconditions.checkNotNull(workerEventLoopGroupPool, "workerEventLoopGroupPool");
        return this;
    }

    void setForceHeapBuffer(boolean value) {
        this.forceHeapBuffer = value;
    }

    public NettyServerBuilder sslContext(SslContext sslContext) {
        if (sslContext != null) {
            Preconditions.checkArgument(sslContext.isServer(), "Client SSL context can not be used for server");
            GrpcSslContexts.ensureAlpnAndH2Enabled(sslContext.applicationProtocolNegotiator());
        }
        this.sslContext = sslContext;
        return this;
    }

    @Internal
    public final NettyServerBuilder protocolNegotiator(@Nullable ProtocolNegotiator protocolNegotiator) {
        this.protocolNegotiator = protocolNegotiator;
        return this;
    }

    @Override
    protected void setTracingEnabled(boolean value) {
        super.setTracingEnabled(value);
    }

    @Override
    protected void setStatsEnabled(boolean value) {
        super.setStatsEnabled(value);
    }

    @Override
    protected void setStatsRecordStartedRpcs(boolean value) {
        super.setStatsRecordStartedRpcs(value);
    }

    @Override
    protected void setStatsRecordRealTimeMetrics(boolean value) {
        super.setStatsRecordRealTimeMetrics(value);
    }

    public NettyServerBuilder maxConcurrentCallsPerConnection(int maxCalls) {
        Preconditions.checkArgument(maxCalls > 0, "max must be positive: %s", maxCalls);
        this.maxConcurrentCallsPerConnection = maxCalls;
        return this;
    }

    public NettyServerBuilder initialFlowControlWindow(int initialFlowControlWindow) {
        Preconditions.checkArgument(initialFlowControlWindow > 0, "initialFlowControlWindow must be positive");
        this.flowControlWindow = initialFlowControlWindow;
        this.autoFlowControl = true;
        return this;
    }

    public NettyServerBuilder flowControlWindow(int flowControlWindow) {
        Preconditions.checkArgument(flowControlWindow > 0, "flowControlWindow must be positive: %s", flowControlWindow);
        this.flowControlWindow = flowControlWindow;
        this.autoFlowControl = false;
        return this;
    }

    @Deprecated
    public NettyServerBuilder maxMessageSize(int maxMessageSize) {
        return this.maxInboundMessageSize(maxMessageSize);
    }

    @Override
    public NettyServerBuilder maxInboundMessageSize(int bytes) {
        Preconditions.checkArgument(bytes >= 0, "bytes must be non-negative: %s", bytes);
        this.maxMessageSize = bytes;
        return this;
    }

    @Deprecated
    public NettyServerBuilder maxHeaderListSize(int maxHeaderListSize) {
        return this.maxInboundMetadataSize(maxHeaderListSize);
    }

    @Override
    public NettyServerBuilder maxInboundMetadataSize(int bytes) {
        Preconditions.checkArgument(bytes > 0, "maxInboundMetadataSize must be positive: %s", bytes);
        this.maxHeaderListSize = bytes;
        return this;
    }

    public NettyServerBuilder keepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        Preconditions.checkArgument(keepAliveTime > 0L, "keepalive time must be positive\uff1a%s", keepAliveTime);
        this.keepAliveTimeInNanos = timeUnit.toNanos(keepAliveTime);
        this.keepAliveTimeInNanos = KeepAliveManager.clampKeepAliveTimeInNanos(this.keepAliveTimeInNanos);
        if (this.keepAliveTimeInNanos >= AS_LARGE_AS_INFINITE) {
            this.keepAliveTimeInNanos = Long.MAX_VALUE;
        }
        if (this.keepAliveTimeInNanos < MIN_KEEPALIVE_TIME_NANO) {
            this.keepAliveTimeInNanos = MIN_KEEPALIVE_TIME_NANO;
        }
        return this;
    }

    public NettyServerBuilder keepAliveTimeout(long keepAliveTimeout, TimeUnit timeUnit) {
        Preconditions.checkArgument(keepAliveTimeout > 0L, "keepalive timeout must be positive: %s", keepAliveTimeout);
        this.keepAliveTimeoutInNanos = timeUnit.toNanos(keepAliveTimeout);
        this.keepAliveTimeoutInNanos = KeepAliveManager.clampKeepAliveTimeoutInNanos(this.keepAliveTimeoutInNanos);
        if (this.keepAliveTimeoutInNanos < MIN_KEEPALIVE_TIMEOUT_NANO) {
            this.keepAliveTimeoutInNanos = MIN_KEEPALIVE_TIMEOUT_NANO;
        }
        return this;
    }

    public NettyServerBuilder maxConnectionIdle(long maxConnectionIdle, TimeUnit timeUnit) {
        Preconditions.checkArgument(maxConnectionIdle > 0L, "max connection idle must be positive: %s", maxConnectionIdle);
        this.maxConnectionIdleInNanos = timeUnit.toNanos(maxConnectionIdle);
        if (this.maxConnectionIdleInNanos >= AS_LARGE_AS_INFINITE) {
            this.maxConnectionIdleInNanos = Long.MAX_VALUE;
        }
        if (this.maxConnectionIdleInNanos < MIN_MAX_CONNECTION_IDLE_NANO) {
            this.maxConnectionIdleInNanos = MIN_MAX_CONNECTION_IDLE_NANO;
        }
        return this;
    }

    public NettyServerBuilder maxConnectionAge(long maxConnectionAge, TimeUnit timeUnit) {
        Preconditions.checkArgument(maxConnectionAge > 0L, "max connection age must be positive: %s", maxConnectionAge);
        this.maxConnectionAgeInNanos = timeUnit.toNanos(maxConnectionAge);
        if (this.maxConnectionAgeInNanos >= AS_LARGE_AS_INFINITE) {
            this.maxConnectionAgeInNanos = Long.MAX_VALUE;
        }
        if (this.maxConnectionAgeInNanos < MIN_MAX_CONNECTION_AGE_NANO) {
            this.maxConnectionAgeInNanos = MIN_MAX_CONNECTION_AGE_NANO;
        }
        return this;
    }

    public NettyServerBuilder maxConnectionAgeGrace(long maxConnectionAgeGrace, TimeUnit timeUnit) {
        Preconditions.checkArgument(maxConnectionAgeGrace >= 0L, "max connection age grace must be non-negative: %s", maxConnectionAgeGrace);
        this.maxConnectionAgeGraceInNanos = timeUnit.toNanos(maxConnectionAgeGrace);
        if (this.maxConnectionAgeGraceInNanos >= AS_LARGE_AS_INFINITE) {
            this.maxConnectionAgeGraceInNanos = Long.MAX_VALUE;
        }
        return this;
    }

    public NettyServerBuilder permitKeepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        Preconditions.checkArgument(keepAliveTime >= 0L, "permit keepalive time must be non-negative: %s", keepAliveTime);
        this.permitKeepAliveTimeInNanos = timeUnit.toNanos(keepAliveTime);
        return this;
    }

    public NettyServerBuilder permitKeepAliveWithoutCalls(boolean permit) {
        this.permitKeepAliveWithoutCalls = permit;
        return this;
    }

    @Override
    @CheckReturnValue
    protected List<NettyServer> buildTransportServers(List<? extends ServerStreamTracer.Factory> streamTracerFactories) {
        this.assertEventLoopsAndChannelType();
        ProtocolNegotiator negotiator = this.protocolNegotiator;
        if (negotiator == null) {
            negotiator = this.sslContext != null ? ProtocolNegotiators.serverTls(this.sslContext, this.getExecutorPool()) : ProtocolNegotiators.serverPlaintext();
        }
        ArrayList<NettyServer> transportServers = new ArrayList<NettyServer>(this.listenAddresses.size());
        for (SocketAddress listenAddress : this.listenAddresses) {
            NettyServer transportServer = new NettyServer(listenAddress, this.channelFactory, this.channelOptions, this.childChannelOptions, this.bossEventLoopGroupPool, this.workerEventLoopGroupPool, this.forceHeapBuffer, negotiator, streamTracerFactories, this.getTransportTracerFactory(), this.maxConcurrentCallsPerConnection, this.autoFlowControl, this.flowControlWindow, this.maxMessageSize, this.maxHeaderListSize, this.keepAliveTimeInNanos, this.keepAliveTimeoutInNanos, this.maxConnectionIdleInNanos, this.maxConnectionAgeInNanos, this.maxConnectionAgeGraceInNanos, this.permitKeepAliveWithoutCalls, this.permitKeepAliveTimeInNanos, this.getChannelz());
            transportServers.add(transportServer);
        }
        return Collections.unmodifiableList(transportServers);
    }

    @VisibleForTesting
    void assertEventLoopsAndChannelType() {
        boolean allProvided = this.channelFactory != Utils.DEFAULT_SERVER_CHANNEL_FACTORY && this.bossEventLoopGroupPool != DEFAULT_BOSS_EVENT_LOOP_GROUP_POOL && this.workerEventLoopGroupPool != DEFAULT_WORKER_EVENT_LOOP_GROUP_POOL;
        boolean nonProvided = this.channelFactory == Utils.DEFAULT_SERVER_CHANNEL_FACTORY && this.bossEventLoopGroupPool == DEFAULT_BOSS_EVENT_LOOP_GROUP_POOL && this.workerEventLoopGroupPool == DEFAULT_WORKER_EVENT_LOOP_GROUP_POOL;
        Preconditions.checkState(allProvided || nonProvided, "All of BossEventLoopGroup, WorkerEventLoopGroup and ChannelType should be provided or neither should be");
    }

    @Override
    public NettyServerBuilder useTransportSecurity(File certChain, File privateKey) {
        try {
            this.sslContext = GrpcSslContexts.forServer(certChain, privateKey).build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public NettyServerBuilder useTransportSecurity(InputStream certChain, InputStream privateKey) {
        try {
            this.sslContext = GrpcSslContexts.forServer(certChain, privateKey).build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
        return this;
    }
}

