/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang3.StringUtils;

public class IoUtils {
    public static String toString(InputStream input, String encoding) throws IOException {
        return null == encoding ? IoUtils.toString(new InputStreamReader(input, "UTF-8")) : IoUtils.toString(new InputStreamReader(input, encoding));
    }

    public static String toString(Reader reader) throws IOException {
        CharArrayWriter sw = new CharArrayWriter();
        IoUtils.copy(reader, sw);
        return sw.toString();
    }

    public static long copy(Reader input, Writer output) throws IOException {
        char[] buffer = new char[4096];
        long count = 0L;
        int n = 0;
        while ((n = input.read(buffer)) >= 0) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        int totalBytes = 0;
        while ((bytesRead = input.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
            totalBytes += bytesRead;
        }
        return totalBytes;
    }

    public static List<String> readLines(Reader input) throws IOException {
        BufferedReader reader = IoUtils.toBufferedReader(input);
        ArrayList<String> list = new ArrayList<String>();
        String line = null;
        while (null != (line = reader.readLine())) {
            if (!StringUtils.isNotEmpty((CharSequence)line)) continue;
            list.add(line.trim());
        }
        return list;
    }

    private static BufferedReader toBufferedReader(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static boolean delete(File fileOrDir) throws IOException {
        if (fileOrDir == null) {
            return false;
        }
        if (fileOrDir.isDirectory()) {
            IoUtils.cleanDirectory(fileOrDir);
        }
        return fileOrDir.delete();
    }

    public static void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of " + directory);
        }
        IOException exception = null;
        for (File file : files) {
            try {
                IoUtils.delete(file);
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(File file, String data, String encoding) throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            ((OutputStream)os).write(data.getBytes(encoding));
            os.flush();
        }
        finally {
            if (null != os) {
                ((OutputStream)os).close();
            }
        }
    }

    public static byte[] tryDecompress(InputStream raw) throws Exception {
        try {
            GZIPInputStream gis = new GZIPInputStream(raw);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IoUtils.copy(gis, out);
            return out.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws IOException {
    }
}

