/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http.client;

import com.alibaba.nacos.common.http.BaseHttpMethod;
import com.alibaba.nacos.common.http.client.DefaultClientHttpResponse;
import com.alibaba.nacos.common.http.client.HttpClientRequest;
import com.alibaba.nacos.common.http.client.HttpClientResponse;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.model.RequestHttpEntity;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpClientRequest
implements HttpClientRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHttpClientRequest.class);
    private final CloseableHttpClient client;

    public DefaultHttpClientRequest(CloseableHttpClient client) {
        this.client = client;
    }

    @Override
    public HttpClientResponse execute(URI uri, String httpMethod, RequestHttpEntity requestHttpEntity) throws Exception {
        HttpRequestBase request = DefaultHttpClientRequest.build(uri, httpMethod, requestHttpEntity);
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Request from server: " + request.getURI().toString());
        }
        return new DefaultClientHttpResponse((HttpResponse)response);
    }

    static HttpRequestBase build(URI uri, String method, RequestHttpEntity requestHttpEntity) throws Exception {
        Header headers = requestHttpEntity.getHeaders();
        BaseHttpMethod httpMethod = BaseHttpMethod.sourceOf(method);
        httpMethod.init(uri.toString());
        httpMethod.initHeader(headers);
        if ("application/x-www-form-urlencoded".equals(headers.getValue("Content-Type")) && requestHttpEntity.getBody() instanceof Map) {
            httpMethod.initFromEntity((Map)requestHttpEntity.getBody(), headers.getCharset());
        } else {
            httpMethod.initEntity(requestHttpEntity.getBody(), headers.getValue("Content-Type"));
        }
        return httpMethod.getRequestBase();
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }
}

