/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.protocol;

import com.alibaba.otter.canal.protocol.CanalEntry;
import com.alibaba.otter.canal.protocol.Message;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FlatMessage
implements Serializable {
    private static final long serialVersionUID = -3386650678735860050L;
    private long id;
    private String database;
    private String table;
    private Boolean isDdl;
    private String type;
    private Long es;
    private Long ts;
    private String sql;
    private Map<String, Integer> sqlType;
    private Map<String, String> mysqlType;
    private List<Map<String, String>> data;
    private List<Map<String, String>> old;

    public FlatMessage() {
    }

    public FlatMessage(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public Boolean getIsDdl() {
        return this.isDdl;
    }

    public void setIsDdl(Boolean isDdl) {
        this.isDdl = isDdl;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Long getTs() {
        return this.ts;
    }

    public void setTs(Long ts) {
        this.ts = ts;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public Map<String, Integer> getSqlType() {
        return this.sqlType;
    }

    public void setSqlType(Map<String, Integer> sqlType) {
        this.sqlType = sqlType;
    }

    public Map<String, String> getMysqlType() {
        return this.mysqlType;
    }

    public void setMysqlType(Map<String, String> mysqlType) {
        this.mysqlType = mysqlType;
    }

    public List<Map<String, String>> getData() {
        return this.data;
    }

    public void setData(List<Map<String, String>> data) {
        this.data = data;
    }

    public List<Map<String, String>> getOld() {
        return this.old;
    }

    public void setOld(List<Map<String, String>> old) {
        this.old = old;
    }

    public Long getEs() {
        return this.es;
    }

    public void setEs(Long es) {
        this.es = es;
    }

    public static List<FlatMessage> messageConverter(Message message) {
        try {
            if (message == null) {
                return null;
            }
            ArrayList<FlatMessage> flatMessages = new ArrayList<FlatMessage>();
            List<CanalEntry.Entry> entrys = null;
            if (message.isRaw()) {
                List<ByteString> rawEntries = message.getRawEntries();
                entrys = new ArrayList<CanalEntry.Entry>(rawEntries.size());
                for (ByteString byteString : rawEntries) {
                    CanalEntry.Entry entry = CanalEntry.Entry.parseFrom(byteString);
                    entrys.add(entry);
                }
            } else {
                entrys = message.getEntries();
            }
            for (CanalEntry.Entry entry : entrys) {
                CanalEntry.RowChange rowChange;
                if (entry.getEntryType() == CanalEntry.EntryType.TRANSACTIONBEGIN || entry.getEntryType() == CanalEntry.EntryType.TRANSACTIONEND) continue;
                try {
                    rowChange = CanalEntry.RowChange.parseFrom(entry.getStoreValue());
                }
                catch (Exception e) {
                    throw new RuntimeException("ERROR ## parser of eromanga-event has an error , data:" + entry.toString(), e);
                }
                CanalEntry.EventType eventType = rowChange.getEventType();
                FlatMessage flatMessage = new FlatMessage(message.getId());
                flatMessages.add(flatMessage);
                flatMessage.setDatabase(entry.getHeader().getSchemaName());
                flatMessage.setTable(entry.getHeader().getTableName());
                flatMessage.setIsDdl(rowChange.getIsDdl());
                flatMessage.setType(eventType.toString());
                flatMessage.setEs(entry.getHeader().getExecuteTime());
                flatMessage.setTs(System.currentTimeMillis());
                flatMessage.setSql(rowChange.getSql());
                if (rowChange.getIsDdl()) continue;
                LinkedHashMap<String, Integer> sqlType = new LinkedHashMap<String, Integer>();
                LinkedHashMap<String, String> mysqlType = new LinkedHashMap<String, String>();
                ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
                ArrayList<Map<String, String>> old = new ArrayList<Map<String, String>>();
                HashSet<String> updateSet = new HashSet<String>();
                for (CanalEntry.RowData rowData : rowChange.getRowDatasList()) {
                    if (eventType != CanalEntry.EventType.INSERT && eventType != CanalEntry.EventType.UPDATE && eventType != CanalEntry.EventType.DELETE) continue;
                    LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
                    List<CanalEntry.Column> columns = eventType == CanalEntry.EventType.DELETE ? rowData.getBeforeColumnsList() : rowData.getAfterColumnsList();
                    for (CanalEntry.Column column : columns) {
                        sqlType.put(column.getName(), column.getSqlType());
                        mysqlType.put(column.getName(), column.getMysqlType());
                        if (column.getIsNull()) {
                            row.put(column.getName(), null);
                        } else {
                            row.put(column.getName(), column.getValue());
                        }
                        if (!column.getUpdated()) continue;
                        updateSet.add(column.getName());
                    }
                    if (!row.isEmpty()) {
                        data.add(row);
                    }
                    if (eventType != CanalEntry.EventType.UPDATE) continue;
                    LinkedHashMap<String, String> rowOld = new LinkedHashMap<String, String>();
                    for (CanalEntry.Column column : rowData.getBeforeColumnsList()) {
                        if (!updateSet.contains(column.getName())) continue;
                        if (column.getIsNull()) {
                            rowOld.put(column.getName(), null);
                            continue;
                        }
                        rowOld.put(column.getName(), column.getValue());
                    }
                    if (rowOld.isEmpty()) continue;
                    old.add(rowOld);
                }
                if (!sqlType.isEmpty()) {
                    flatMessage.setSqlType(sqlType);
                }
                if (!mysqlType.isEmpty()) {
                    flatMessage.setMysqlType(mysqlType);
                }
                if (!data.isEmpty()) {
                    flatMessage.setData(data);
                }
                if (old.isEmpty()) continue;
                flatMessage.setOld(old);
            }
            return flatMessages;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static FlatMessage[] messagePartition(FlatMessage flatMessage, Integer partitionsNum, Map<String, String> pkHashConfig) {
        if (partitionsNum == null) {
            partitionsNum = 1;
        }
        FlatMessage[] partitionMessages = new FlatMessage[partitionsNum.intValue()];
        String pk = pkHashConfig.get(flatMessage.getDatabase() + "." + flatMessage.getTable());
        if (pk == null || flatMessage.getIsDdl().booleanValue()) {
            partitionMessages[0] = flatMessage;
        } else if (flatMessage.getData() != null) {
            int idx = 0;
            for (Map<String, String> row : flatMessage.getData()) {
                List<Map<String, String>> data;
                String value = row.get(pk);
                if (value == null) {
                    value = "";
                }
                int hash = value.hashCode();
                int pkHash = Math.abs(hash) % partitionsNum;
                FlatMessage flatMessageTmp = partitionMessages[pkHash = Math.abs(pkHash)];
                if (flatMessageTmp == null) {
                    partitionMessages[pkHash] = flatMessageTmp = new FlatMessage(flatMessage.getId());
                    flatMessageTmp.setDatabase(flatMessage.getDatabase());
                    flatMessageTmp.setTable(flatMessage.getTable());
                    flatMessageTmp.setIsDdl(flatMessage.getIsDdl());
                    flatMessageTmp.setType(flatMessage.getType());
                    flatMessageTmp.setSql(flatMessage.getSql());
                    flatMessageTmp.setSqlType(flatMessage.getSqlType());
                    flatMessageTmp.setMysqlType(flatMessage.getMysqlType());
                    flatMessageTmp.setEs(flatMessage.getEs());
                    flatMessageTmp.setTs(flatMessage.getTs());
                }
                if ((data = flatMessageTmp.getData()) == null) {
                    data = new ArrayList<Map<String, String>>();
                    flatMessageTmp.setData(data);
                }
                data.add(row);
                if (flatMessage.getOld() != null && !flatMessage.getOld().isEmpty()) {
                    List<Map<String, String>> old = flatMessageTmp.getOld();
                    if (old == null) {
                        old = new ArrayList<Map<String, String>>();
                        flatMessageTmp.setOld(old);
                    }
                    old.add(flatMessage.getOld().get(idx));
                }
                ++idx;
            }
        }
        return partitionMessages;
    }

    public String toString() {
        return "FlatMessage [id=" + this.id + ", database=" + this.database + ", table=" + this.table + ", isDdl=" + this.isDdl + ", type=" + this.type + ", es=" + this.es + ", ts=" + this.ts + ", sql=" + this.sql + ", sqlType=" + this.sqlType + ", mysqlType=" + this.mysqlType + ", data=" + this.data + ", old=" + this.old + "]";
    }
}

