/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.instance.manager;

import com.alibaba.otter.canal.common.CanalException;
import com.alibaba.otter.canal.instance.core.CanalInstance;
import com.alibaba.otter.canal.instance.core.CanalInstanceGenerator;
import com.alibaba.otter.canal.instance.manager.plain.PlainCanal;
import com.alibaba.otter.canal.instance.manager.plain.PlainCanalConfigClient;
import com.alibaba.otter.canal.instance.spring.SpringCanalInstanceGenerator;
import com.alibaba.otter.canal.instance.spring.support.PropertyPlaceholderConfigurer;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class PlainCanalInstanceGenerator
implements CanalInstanceGenerator {
    private static final Logger logger = LoggerFactory.getLogger(SpringCanalInstanceGenerator.class);
    private String springXml;
    private PlainCanalConfigClient canalConfigClient;
    private String defaultName = "instance";
    private BeanFactory beanFactory;
    private Properties canalConfig;

    public PlainCanalInstanceGenerator(Properties canalConfig) {
        this.canalConfig = canalConfig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CanalInstance generate(String destination) {
        Class<CanalInstanceGenerator> clazz = CanalInstanceGenerator.class;
        synchronized (CanalInstanceGenerator.class) {
            try {
                PlainCanal canal = this.canalConfigClient.findInstance(destination, null);
                if (canal == null) {
                    throw new CanalException("instance : " + destination + " config is not found");
                }
                Properties properties = canal.getProperties();
                properties.putAll((Map<?, ?>)this.canalConfig);
                PropertyPlaceholderConfigurer.propertiesLocal.set(properties);
                System.setProperty("canal.instance.destination", destination);
                this.beanFactory = this.getBeanFactory(this.springXml);
                String beanName = destination;
                if (!this.beanFactory.containsBean(beanName)) {
                    beanName = this.defaultName;
                }
                CanalInstance canalInstance = (CanalInstance)this.beanFactory.getBean(beanName);
                // ** MonitorExit[clazz] (shouldn't be in output)
                return canalInstance;
            }
            catch (Throwable e) {
                logger.error("generator instance failed.", e);
                throw new CanalException(e);
            }
            finally {
                System.setProperty("canal.instance.destination", "");
            }
        }
    }

    private BeanFactory getBeanFactory(String springXml) {
        ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext(springXml);
        return applicationContext;
    }

    public void setCanalConfigClient(PlainCanalConfigClient canalConfigClient) {
        this.canalConfigClient = canalConfigClient;
    }

    public void setSpringXml(String springXml) {
        this.springXml = springXml;
    }
}

