/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.meta;

import com.alibaba.otter.canal.common.utils.JsonUtils;
import com.alibaba.otter.canal.meta.CanalMetaManager;
import com.alibaba.otter.canal.meta.MemoryMetaManager;
import com.alibaba.otter.canal.meta.exception.CanalMetaManagerException;
import com.alibaba.otter.canal.protocol.ClientIdentity;
import com.alibaba.otter.canal.protocol.position.LogPosition;
import com.alibaba.otter.canal.protocol.position.Position;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.MigrateMap;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.util.Assert;

public class FileMixedMetaManager
extends MemoryMetaManager
implements CanalMetaManager {
    private static final Logger logger = LoggerFactory.getLogger(FileMixedMetaManager.class);
    private static final Charset charset = Charset.forName("UTF-8");
    private File dataDir;
    private String dataFileName = "meta.dat";
    private Map<String, File> dataFileCaches;
    private ScheduledExecutorService executor;
    private final Position nullCursor = new Position(){};
    private long period = 1000L;
    private Set<ClientIdentity> updateCursorTasks;

    @Override
    public void start() {
        super.start();
        Assert.notNull((Object)this.dataDir);
        if (!this.dataDir.exists()) {
            try {
                FileUtils.forceMkdir((File)this.dataDir);
            }
            catch (IOException e) {
                throw new CanalMetaManagerException(e);
            }
        }
        if (!this.dataDir.canRead() || !this.dataDir.canWrite()) {
            throw new CanalMetaManagerException("dir[" + this.dataDir.getPath() + "] can not read/write");
        }
        this.dataFileCaches = MigrateMap.makeComputingMap((Function)new Function<String, File>(){

            public File apply(String destination) {
                return FileMixedMetaManager.this.getDataFile(destination);
            }
        });
        this.executor = Executors.newScheduledThreadPool(1);
        this.destinations = MigrateMap.makeComputingMap((Function)new Function<String, List<ClientIdentity>>(){

            public List<ClientIdentity> apply(String destination) {
                return FileMixedMetaManager.this.loadClientIdentity(destination);
            }
        });
        this.cursors = MigrateMap.makeComputingMap((Function)new Function<ClientIdentity, Position>(){

            public Position apply(ClientIdentity clientIdentity) {
                Position position = FileMixedMetaManager.this.loadCursor(clientIdentity.getDestination(), clientIdentity);
                if (position == null) {
                    return FileMixedMetaManager.this.nullCursor;
                }
                return position;
            }
        });
        this.updateCursorTasks = Collections.synchronizedSet(new HashSet());
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ArrayList tasks = new ArrayList(FileMixedMetaManager.this.updateCursorTasks);
                for (ClientIdentity clientIdentity : tasks) {
                    MDC.put((String)"destination", (String)String.valueOf(clientIdentity.getDestination()));
                    try {
                        if (logger.isInfoEnabled()) {
                            LogPosition cursor = (LogPosition)FileMixedMetaManager.this.getCursor(clientIdentity);
                            logger.info("clientId:{} cursor:[{},{},{},{},{}] address[{}]", new Object[]{clientIdentity.getClientId(), cursor.getPostion().getJournalName(), cursor.getPostion().getPosition(), cursor.getPostion().getTimestamp(), cursor.getPostion().getServerId(), cursor.getPostion().getGtid(), cursor.getIdentity().getSourceAddress().toString()});
                        }
                        FileMixedMetaManager.this.flushDataToFile(clientIdentity.getDestination());
                        FileMixedMetaManager.this.updateCursorTasks.remove(clientIdentity);
                    }
                    catch (Throwable e) {
                        logger.error("period update" + clientIdentity.toString() + " curosr failed!", e);
                    }
                }
            }
        }, this.period, this.period, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        super.stop();
        this.flushDataToFile();
        this.executor.shutdownNow();
        this.destinations.clear();
        this.batches.clear();
    }

    @Override
    public void subscribe(final ClientIdentity clientIdentity) throws CanalMetaManagerException {
        super.subscribe(clientIdentity);
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                FileMixedMetaManager.this.flushDataToFile(clientIdentity.getDestination());
            }
        });
    }

    @Override
    public void unsubscribe(final ClientIdentity clientIdentity) throws CanalMetaManagerException {
        super.unsubscribe(clientIdentity);
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                FileMixedMetaManager.this.flushDataToFile(clientIdentity.getDestination());
            }
        });
    }

    @Override
    public void updateCursor(ClientIdentity clientIdentity, Position position) throws CanalMetaManagerException {
        this.updateCursorTasks.add(clientIdentity);
        super.updateCursor(clientIdentity, position);
    }

    @Override
    public Position getCursor(ClientIdentity clientIdentity) throws CanalMetaManagerException {
        Position position = super.getCursor(clientIdentity);
        if (position == this.nullCursor) {
            return null;
        }
        return position;
    }

    private File getDataFile(String destination) {
        File destinationMetaDir = new File(this.dataDir, destination);
        if (!destinationMetaDir.exists()) {
            try {
                FileUtils.forceMkdir((File)destinationMetaDir);
            }
            catch (IOException e) {
                throw new CanalMetaManagerException(e);
            }
        }
        return new File(destinationMetaDir, this.dataFileName);
    }

    private FileMetaInstanceData loadDataFromFile(File dataFile) {
        try {
            if (!dataFile.exists()) {
                return null;
            }
            String json = FileUtils.readFileToString((File)dataFile, (String)charset.name());
            return (FileMetaInstanceData)JsonUtils.unmarshalFromString((String)json, FileMetaInstanceData.class);
        }
        catch (IOException e) {
            throw new CanalMetaManagerException(e);
        }
    }

    private void flushDataToFile() {
        for (String destination : this.destinations.keySet()) {
            this.flushDataToFile(destination);
        }
    }

    private void flushDataToFile(String destination) {
        this.flushDataToFile(destination, this.dataFileCaches.get(destination));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushDataToFile(String destination, File dataFile) {
        FileMetaInstanceData data = new FileMetaInstanceData();
        if (this.destinations.containsKey(destination)) {
            String string = destination.intern();
            synchronized (string) {
                data.setDestination(destination);
                ArrayList clientDatas = Lists.newArrayList();
                List clientIdentitys = (List)this.destinations.get(destination);
                for (ClientIdentity clientIdentity : clientIdentitys) {
                    FileMetaClientIdentityData clientData = new FileMetaClientIdentityData();
                    clientData.setClientIdentity(clientIdentity);
                    Position position = (Position)this.cursors.get(clientIdentity);
                    if (position != null && position != this.nullCursor) {
                        clientData.setCursor((LogPosition)position);
                    }
                    clientDatas.add(clientData);
                }
                data.setClientDatas(clientDatas);
            }
            String json = JsonUtils.marshalToString((Object)data);
            try {
                FileUtils.writeStringToFile((File)dataFile, (String)json);
            }
            catch (IOException e) {
                throw new CanalMetaManagerException(e);
            }
        }
    }

    private List<ClientIdentity> loadClientIdentity(String destination) {
        ArrayList result = Lists.newArrayList();
        FileMetaInstanceData data = this.loadDataFromFile(this.dataFileCaches.get(destination));
        if (data == null) {
            return result;
        }
        List<FileMetaClientIdentityData> clientDatas = data.getClientDatas();
        if (clientDatas == null) {
            return result;
        }
        for (FileMetaClientIdentityData clientData : clientDatas) {
            if (!clientData.getClientIdentity().getDestination().equals(destination)) continue;
            result.add(clientData.getClientIdentity());
        }
        return result;
    }

    private Position loadCursor(String destination, ClientIdentity clientIdentity) {
        FileMetaInstanceData data = this.loadDataFromFile(this.dataFileCaches.get(destination));
        if (data == null) {
            return null;
        }
        List<FileMetaClientIdentityData> clientDatas = data.getClientDatas();
        if (clientDatas == null) {
            return null;
        }
        for (FileMetaClientIdentityData clientData : clientDatas) {
            if (clientData.getClientIdentity() == null || !clientData.getClientIdentity().equals((Object)clientIdentity)) continue;
            return clientData.getCursor();
        }
        return null;
    }

    public void setDataDir(String dataDir) {
        this.dataDir = new File(dataDir);
    }

    public void setDataDirByFile(File dataDir) {
        this.dataDir = dataDir;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public static class FileMetaInstanceData {
        private String destination;
        private List<FileMetaClientIdentityData> clientDatas;

        public FileMetaInstanceData() {
        }

        public FileMetaInstanceData(String destination, List<FileMetaClientIdentityData> clientDatas) {
            this.destination = destination;
            this.clientDatas = clientDatas;
        }

        public String getDestination() {
            return this.destination;
        }

        public void setDestination(String destination) {
            this.destination = destination;
        }

        public List<FileMetaClientIdentityData> getClientDatas() {
            return this.clientDatas;
        }

        public void setClientDatas(List<FileMetaClientIdentityData> clientDatas) {
            this.clientDatas = clientDatas;
        }
    }

    public static class FileMetaClientIdentityData {
        private ClientIdentity clientIdentity;
        private LogPosition cursor;

        public FileMetaClientIdentityData() {
        }

        public FileMetaClientIdentityData(ClientIdentity clientIdentity, MemoryMetaManager.MemoryClientIdentityBatch batch, LogPosition cursor) {
            this.clientIdentity = clientIdentity;
            this.cursor = cursor;
        }

        public ClientIdentity getClientIdentity() {
            return this.clientIdentity;
        }

        public void setClientIdentity(ClientIdentity clientIdentity) {
            this.clientIdentity = clientIdentity;
        }

        public Position getCursor() {
            return this.cursor;
        }

        public void setCursor(LogPosition cursor) {
            this.cursor = cursor;
        }
    }
}

