/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.dbsync.binlog.event;

import com.taobao.tddl.dbsync.binlog.LogBuffer;
import com.taobao.tddl.dbsync.binlog.LogEvent;
import com.taobao.tddl.dbsync.binlog.event.FormatDescriptionLogEvent;
import com.taobao.tddl.dbsync.binlog.event.LogHeader;

public class XaPrepareLogEvent
extends LogEvent {
    private boolean onePhase;
    private int formatId;
    private int gtridLength;
    private int bqualLength;
    private byte[] data;

    public XaPrepareLogEvent(LogHeader header, LogBuffer buffer, FormatDescriptionLogEvent descriptionEvent) {
        super(header);
        int commonHeaderLen = descriptionEvent.getCommonHeaderLen();
        short postHeaderLen = descriptionEvent.getPostHeaderLen()[header.getType() - 1];
        int offset = commonHeaderLen + postHeaderLen;
        buffer.position(offset);
        this.onePhase = buffer.getInt8() != 0;
        this.formatId = buffer.getInt32();
        this.gtridLength = buffer.getInt32();
        this.bqualLength = buffer.getInt32();
        int MY_XIDDATASIZE = 128;
        if (MY_XIDDATASIZE >= this.gtridLength + this.bqualLength && this.gtridLength >= 0 && this.gtridLength <= 64 && this.bqualLength >= 0 && this.bqualLength <= 64) {
            this.data = buffer.getData(this.gtridLength + this.bqualLength);
        } else {
            this.formatId = -1;
            this.gtridLength = 0;
            this.bqualLength = 0;
        }
    }

    public boolean isOnePhase() {
        return this.onePhase;
    }

    public int getFormatId() {
        return this.formatId;
    }

    public int getGtridLength() {
        return this.gtridLength;
    }

    public int getBqualLength() {
        return this.bqualLength;
    }

    public byte[] getData() {
        return this.data;
    }
}

