/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.driver.mysql.packets;

import com.alibaba.otter.canal.parse.driver.mysql.packets.GTIDSet;
import com.alibaba.otter.canal.parse.driver.mysql.packets.UUIDSet;
import com.alibaba.otter.canal.parse.driver.mysql.utils.ByteHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MysqlGTIDSet
implements GTIDSet {
    public Map<String, UUIDSet> sets;

    @Override
    public byte[] encode() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteHelper.writeUnsignedInt64LittleEndian(this.sets.size(), out);
        for (Map.Entry<String, UUIDSet> entry : this.sets.entrySet()) {
            out.write(entry.getValue().encode());
        }
        return out.toByteArray();
    }

    @Override
    public void update(String str) {
        UUIDSet us = UUIDSet.parse(str);
        String sid = us.SID.toString();
        if (this.sets.containsKey(sid)) {
            this.sets.get((Object)sid).intervals.addAll(us.intervals);
            this.sets.get((Object)sid).intervals = UUIDSet.combine(this.sets.get((Object)sid).intervals);
        } else {
            this.sets.put(sid, us);
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        MysqlGTIDSet gs = (MysqlGTIDSet)o;
        if (gs.sets == null) {
            return false;
        }
        for (Map.Entry<String, UUIDSet> entry : this.sets.entrySet()) {
            if (entry.getValue().equals(gs.sets.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public static MysqlGTIDSet parse(String gtidData) {
        HashMap<String, UUIDSet> m;
        if (gtidData == null || gtidData.length() < 1) {
            m = new HashMap<String, UUIDSet>();
        } else {
            String[] uuidStrs = gtidData.replaceAll("\n", "").split(",");
            m = new HashMap(uuidStrs.length);
            for (int i = 0; i < uuidStrs.length; ++i) {
                UUIDSet uuidSet = UUIDSet.parse(uuidStrs[i]);
                m.put(uuidSet.SID.toString(), uuidSet);
            }
        }
        MysqlGTIDSet gs = new MysqlGTIDSet();
        gs.sets = m;
        return gs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, UUIDSet> entry : this.sets.entrySet()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(entry.getValue().toString());
        }
        return sb.toString();
    }
}

