/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.inbound.mysql.rds.request;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

public abstract class AbstractRequest<T> {
    private static final String ENCODING = "UTF-8";
    private static final String MAC_NAME = "HmacSHA1";
    private String accessKeyId;
    private String accessKeySecret;
    private String version;
    private String endPoint = "rds.aliyuncs.com";
    private String protocol = "http";
    private int timeout = (int)TimeUnit.MINUTES.toMillis(1L);
    private Map<String, String> treeMap = new TreeMap<String, String>();

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void putQueryString(String name, String value) {
        if (StringUtils.isBlank((String)name) || StringUtils.isBlank((String)value)) {
            return;
        }
        this.treeMap.put(name, value);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    private byte[] HmacSHA1Encrypt(String encryptText, String encryptKey) throws Exception {
        byte[] data = encryptKey.getBytes(ENCODING);
        SecretKeySpec secretKey = new SecretKeySpec(data, MAC_NAME);
        Mac mac = Mac.getInstance(MAC_NAME);
        mac.init(secretKey);
        byte[] text = encryptText.getBytes(ENCODING);
        return mac.doFinal(text);
    }

    private String base64(byte[] input) throws UnsupportedEncodingException {
        return new String(Base64.encodeBase64((byte[])input), ENCODING);
    }

    private String concatQueryString(Map<String, String> parameters) throws UnsupportedEncodingException {
        if (null == parameters) {
            return null;
        }
        StringBuilder urlBuilder = new StringBuilder("");
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            urlBuilder.append(this.encode(key));
            if (val != null) {
                urlBuilder.append("=").append(this.encode(val));
            }
            urlBuilder.append("&");
        }
        int strIndex = urlBuilder.length();
        if (parameters.size() > 0) {
            urlBuilder.deleteCharAt(strIndex - 1);
        }
        return urlBuilder.toString();
    }

    private String encode(String value) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, ENCODING);
    }

    private String makeSignature(TreeMap<String, String> paramMap) throws Exception {
        String cqs = this.concatQueryString(paramMap);
        cqs = this.encode(cqs);
        cqs = cqs.replaceAll("\\+", "%20");
        cqs = cqs.replaceAll("\\*", "%2A");
        cqs = cqs.replaceAll("%7E", "~");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GET").append("&").append(this.encode("/")).append("&").append(cqs);
        return this.base64(this.HmacSHA1Encrypt(stringBuilder.toString(), this.accessKeySecret + "&"));
    }

    public final String formatUTCTZ(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(date);
    }

    private void fillCommonParam(Map<String, String> p) {
        p.put("Format", "JSON");
        p.put("Version", this.version);
        p.put("AccessKeyId", this.accessKeyId);
        p.put("SignatureMethod", "HMAC-SHA1");
        p.put("Timestamp", this.formatUTCTZ(new Date()));
        p.put("SignatureVersion", "1.0");
        p.put("SignatureNonce", UUID.randomUUID().toString());
    }

    private String makeRequestString(Map<String, String> param) throws Exception {
        this.fillCommonParam(param);
        String sign = this.makeSignature(new TreeMap<String, String>(param));
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : param.entrySet()) {
            builder.append(this.encode(entry.getKey())).append("=").append(this.encode(entry.getValue())).append("&");
        }
        builder.append("Signature").append("=").append(sign);
        return builder.toString();
    }

    private final HttpResponse executeHttpRequest(HttpGet getMethod, String host) throws Exception {
        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                return true;
            }
        }).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)sslsf).build();
        PoolingHttpClientConnectionManager httpClientConnectionManager = new PoolingHttpClientConnectionManager(registry);
        CloseableHttpClient httpClient = HttpClientBuilder.create().setMaxConnPerRoute(50).setMaxConnTotal(100).setConnectionManager((HttpClientConnectionManager)httpClientConnectionManager).build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.timeout).setConnectionRequestTimeout(this.timeout).setSocketTimeout(this.timeout).build();
        getMethod.setConfig(requestConfig);
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)getMethod);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != HttpResponseStatus.OK.code() && statusCode != HttpResponseStatus.PARTIAL_CONTENT.code()) {
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            throw new RuntimeException("return error !" + response.getStatusLine().getReasonPhrase() + ", " + result);
        }
        return response;
    }

    protected abstract T processResult(HttpResponse var1) throws Exception;

    protected void processBefore() {
    }

    public final T doAction() throws Exception {
        this.processBefore();
        String requestStr = this.makeRequestString(this.treeMap);
        HttpGet httpGet = new HttpGet(this.protocol + "://" + this.endPoint + "?" + requestStr);
        HttpResponse response = this.executeHttpRequest(httpGet, this.endPoint);
        if (response.getStatusLine().getStatusCode() != 200) {
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            throw new RuntimeException("http request failed! " + result);
        }
        return this.processResult(response);
    }
}

