/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.index;

import com.alibaba.otter.canal.parse.exception.CanalParseException;
import com.alibaba.otter.canal.parse.index.AbstractLogPositionManager;
import com.alibaba.otter.canal.parse.index.CanalLogPositionManager;
import com.alibaba.otter.canal.protocol.position.LogPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailbackLogPositionManager
extends AbstractLogPositionManager {
    private static final Logger logger = LoggerFactory.getLogger(FailbackLogPositionManager.class);
    private final CanalLogPositionManager primary;
    private final CanalLogPositionManager secondary;

    public FailbackLogPositionManager(CanalLogPositionManager primary, CanalLogPositionManager secondary) {
        if (primary == null) {
            throw new NullPointerException("nul primary LogPositionManager");
        }
        if (secondary == null) {
            throw new NullPointerException("nul secondary LogPositionManager");
        }
        this.primary = primary;
        this.secondary = secondary;
    }

    public void start() {
        super.start();
        if (!this.primary.isStart()) {
            this.primary.start();
        }
        if (!this.secondary.isStart()) {
            this.secondary.start();
        }
    }

    public void stop() {
        super.stop();
        if (this.secondary.isStart()) {
            this.secondary.stop();
        }
        if (this.primary.isStart()) {
            this.primary.stop();
        }
    }

    @Override
    public LogPosition getLatestIndexBy(String destination) {
        LogPosition logPosition = this.primary.getLatestIndexBy(destination);
        if (logPosition != null) {
            return logPosition;
        }
        return this.secondary.getLatestIndexBy(destination);
    }

    @Override
    public void persistLogPosition(String destination, LogPosition logPosition) throws CanalParseException {
        try {
            this.primary.persistLogPosition(destination, logPosition);
        }
        catch (CanalParseException e) {
            logger.warn("persistLogPosition use primary log position manager exception. destination: {}, logPosition: {}", new Object[]{destination, logPosition, e});
            this.secondary.persistLogPosition(destination, logPosition);
        }
    }
}

