/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.admin.handler;

import com.alibaba.otter.canal.admin.handler.ClientAuthenticationHandler;
import com.alibaba.otter.canal.admin.netty.AdminNettyUtils;
import com.alibaba.otter.canal.protocol.AdminPacket;
import com.google.protobuf.ByteString;
import org.apache.commons.lang3.RandomUtils;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandshakeInitializationHandler
extends SimpleChannelHandler {
    private ChannelGroup childGroups;
    private static final Logger logger = LoggerFactory.getLogger(HandshakeInitializationHandler.class);

    public HandshakeInitializationHandler(ChannelGroup childGroups) {
        this.childGroups = childGroups;
    }

    public void channelOpen(final ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this.childGroups != null) {
            this.childGroups.add((Object)ctx.getChannel());
        }
        final byte[] seed = RandomUtils.nextBytes((int)8);
        byte[] body = AdminPacket.Packet.newBuilder().setType(AdminPacket.PacketType.HANDSHAKE).setVersion(AdminNettyUtils.VERSION).setBody(AdminPacket.Handshake.newBuilder().setSeeds(ByteString.copyFrom((byte[])seed)).build().toByteString()).build().toByteArray();
        AdminNettyUtils.write(ctx.getChannel(), body, new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                logger.info("remove unused channel handlers after authentication is done successfully.");
                ctx.getPipeline().get(HandshakeInitializationHandler.class.getName());
                ClientAuthenticationHandler handler = (ClientAuthenticationHandler)ctx.getPipeline().get(ClientAuthenticationHandler.class.getName());
                handler.setSeed(seed);
            }
        });
        logger.info("send handshake initialization packet to : {}", (Object)ctx.getChannel());
    }
}

