/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.common;

import com.alibaba.otter.canal.protocol.CanalEntry;
import com.alibaba.otter.canal.protocol.CanalPacket;
import com.alibaba.otter.canal.protocol.Message;
import com.alibaba.otter.canal.server.netty.NettyUtils;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream;
import java.util.Collection;
import java.util.List;
import org.apache.kafka.common.errors.SerializationException;
import org.springframework.util.CollectionUtils;

public class CanalMessageSerializer {
    public static byte[] serializer(Message data, boolean filterTransactionEntry) {
        try {
            if (data != null && data.getId() != -1L) {
                if (data.isRaw() && !CollectionUtils.isEmpty((Collection)data.getRawEntries())) {
                    List rowEntries = data.getRawEntries();
                    int messageSize = 0;
                    messageSize += CodedOutputStream.computeInt64Size((int)1, (long)data.getId());
                    int dataSize = 0;
                    for (int i = 0; i < rowEntries.size(); ++i) {
                        dataSize += CodedOutputStream.computeBytesSizeNoTag((ByteString)((ByteString)rowEntries.get(i)));
                    }
                    messageSize += dataSize;
                    int size = 0;
                    size += CodedOutputStream.computeEnumSize((int)3, (int)CanalPacket.PacketType.MESSAGES.getNumber());
                    byte[] body = new byte[size += CodedOutputStream.computeTagSize((int)5) + CodedOutputStream.computeRawVarint32Size((int)(messageSize += 1 * rowEntries.size())) + messageSize];
                    CodedOutputStream output = CodedOutputStream.newInstance((byte[])body);
                    output.writeEnum(3, CanalPacket.PacketType.MESSAGES.getNumber());
                    output.writeTag(5, 2);
                    output.writeRawVarint32(messageSize);
                    output.writeInt64(1, data.getId());
                    for (int i = 0; i < rowEntries.size(); ++i) {
                        output.writeBytes(2, (ByteString)rowEntries.get(i));
                    }
                    output.checkNoSpaceLeft();
                    return body;
                }
                if (!CollectionUtils.isEmpty((Collection)data.getEntries())) {
                    CanalPacket.Messages.Builder messageBuilder = CanalPacket.Messages.newBuilder();
                    for (CanalEntry.Entry entry : data.getEntries()) {
                        if (filterTransactionEntry && (entry.getEntryType() == CanalEntry.EntryType.TRANSACTIONBEGIN || entry.getEntryType() == CanalEntry.EntryType.TRANSACTIONEND)) continue;
                        messageBuilder.addMessages(entry.toByteString());
                    }
                    CanalPacket.Packet.Builder packetBuilder = CanalPacket.Packet.newBuilder();
                    packetBuilder.setType(CanalPacket.PacketType.MESSAGES);
                    packetBuilder.setVersion(NettyUtils.VERSION);
                    packetBuilder.setBody(messageBuilder.build().toByteString());
                    return packetBuilder.build().toByteArray();
                }
            }
        }
        catch (Exception e) {
            throw new SerializationException("Error when serializing message to byte[] ");
        }
        return null;
    }
}

