/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.spi;

import com.alibaba.ttl.TtlUnwrap;
import com.alibaba.ttl.spi.TtlAttachments;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TtlAttachmentsDelegate
implements TtlAttachments {
    private final ConcurrentMap<String, Object> attachments = new ConcurrentHashMap<String, Object>();

    @Override
    public void setTtlAttachment(@NonNull String key, Object value) {
        this.attachments.put(key, value);
    }

    @Override
    public <T> T getTtlAttachment(@NonNull String key) {
        return (T)this.attachments.get(key);
    }

    public static boolean isAutoWrapper(@Nullable Object ttlAttachments) {
        if (TtlAttachmentsDelegate.notTtlAttachments(ttlAttachments)) {
            return false;
        }
        Boolean value = (Boolean)((TtlAttachments)ttlAttachments).getTtlAttachment("ttl.is.auto.wrapper");
        if (value == null) {
            return false;
        }
        return value;
    }

    public static void setAutoWrapperAttachment(@Nullable Object ttlAttachment) {
        if (TtlAttachmentsDelegate.notTtlAttachments(ttlAttachment)) {
            return;
        }
        ((TtlAttachments)ttlAttachment).setTtlAttachment("ttl.is.auto.wrapper", true);
    }

    @Nullable
    public static <T> T unwrapIfIsAutoWrapper(@Nullable T obj) {
        if (TtlAttachmentsDelegate.isAutoWrapper(obj)) {
            return TtlUnwrap.unwrap(obj);
        }
        return obj;
    }

    private static boolean notTtlAttachments(@Nullable Object ttlAttachment) {
        return !(ttlAttachment instanceof TtlAttachments);
    }
}

