/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent;

import com.alibaba.ttl.threadpool.agent.TtlAgentHelper;
import com.alibaba.ttl.threadpool.agent.TtlTransformer;
import com.alibaba.ttl.threadpool.agent.logging.Logger;
import com.alibaba.ttl.threadpool.agent.transformlet.TtlTransformlet;
import com.alibaba.ttl.threadpool.agent.transformlet.internal.ForkJoinTtlTransformlet;
import com.alibaba.ttl.threadpool.agent.transformlet.internal.JdkExecutorTtlTransformlet;
import com.alibaba.ttl.threadpool.agent.transformlet.internal.TimerTaskTtlTransformlet;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class TtlAgent {
    public static final String TTL_AGENT_LOGGER_KEY = "ttl.agent.logger";
    public static final String TTL_AGENT_DISABLE_INHERITABLE_FOR_THREAD_POOL_KEY = "ttl.agent.disable.inheritable.for.thread.pool";
    public static final String TTL_AGENT_ENABLE_TIMER_TASK_KEY = "ttl.agent.enable.timer.task";
    public static final String TTL_AGENT_LOG_CLASS_TRANSFORM_KEY = "ttl.agent.log.class.transform";
    private static volatile Map<String, String> kvs;
    private static volatile boolean ttlAgentLoaded;

    public static void premain(String agentArgs, @NonNull Instrumentation inst) {
        kvs = TtlAgentHelper.splitCommaColonStringToKV(agentArgs);
        Logger.setLoggerImplType(TtlAgent.getLoggerType());
        Logger logger = Logger.getLogger(TtlAgent.class);
        try {
            logger.info("[TtlAgent.premain] begin, agentArgs: " + agentArgs + ", Instrumentation: " + inst);
            logger.info(TtlAgent.logTtlAgentConfig());
            ArrayList<TtlTransformlet> transformletList = new ArrayList<TtlTransformlet>();
            transformletList.add(new JdkExecutorTtlTransformlet());
            transformletList.add(new ForkJoinTtlTransformlet());
            if (TtlAgent.isEnableTimerTask()) {
                transformletList.add(new TimerTaskTtlTransformlet());
            }
            TtlTransformer transformer = new TtlTransformer(transformletList, TtlAgent.isLogClassTransform());
            inst.addTransformer(transformer, true);
            logger.info("[TtlAgent.premain] add Transformer " + transformer.getClass().getName() + " success");
            logger.info("[TtlAgent.premain] end");
            ttlAgentLoaded = true;
        }
        catch (Exception e) {
            String msg = "Fail to load TtlAgent , cause: " + e.toString();
            logger.error(msg, e);
            throw new IllegalStateException(msg, e);
        }
    }

    private static String logTtlAgentConfig() {
        return "TTL Agent configurations:\n    ttl.agent.logger=" + TtlAgent.getLoggerType() + "\n    " + TTL_AGENT_LOG_CLASS_TRANSFORM_KEY + "=" + TtlAgent.isLogClassTransform() + "\n    " + TTL_AGENT_DISABLE_INHERITABLE_FOR_THREAD_POOL_KEY + "=" + TtlAgent.isDisableInheritableForThreadPool() + "\n    " + TTL_AGENT_ENABLE_TIMER_TASK_KEY + "=" + TtlAgent.isEnableTimerTask();
    }

    public static boolean isTtlAgentLoaded() {
        return ttlAgentLoaded;
    }

    public static boolean isDisableInheritableForThreadPool() {
        return TtlAgent.isBooleanOptionSet(TTL_AGENT_DISABLE_INHERITABLE_FOR_THREAD_POOL_KEY);
    }

    public static boolean isEnableTimerTask() {
        return TtlAgent.isBooleanOptionSet(TTL_AGENT_ENABLE_TIMER_TASK_KEY, true);
    }

    public static boolean isLogClassTransform() {
        return TtlAgent.isBooleanOptionSet(TTL_AGENT_LOG_CLASS_TRANSFORM_KEY);
    }

    @NonNull
    public static String getLoggerType() {
        return TtlAgent.getStringOptionValue(TTL_AGENT_LOGGER_KEY, "STDERR");
    }

    public static boolean isBooleanOptionSet(@NonNull String key) {
        return TtlAgent.isBooleanOptionSet(key, false);
    }

    public static boolean isBooleanOptionSet(@NonNull String key, boolean defaultValueIfKeyAbsent) {
        return TtlAgentHelper.isBooleanOptionSet(kvs, key, defaultValueIfKeyAbsent);
    }

    @NonNull
    public static String getStringOptionValue(@NonNull String key, @NonNull String defaultValue) {
        return TtlAgentHelper.getStringOptionValue(kvs, key, defaultValue);
    }

    @NonNull
    static List<String> getOptionStringListValues(@NonNull String key) {
        return TtlAgentHelper.getOptionStringListValues(kvs, key);
    }

    private TtlAgent() {
        throw new InstantiationError("Must not instantiate this class");
    }

    static {
        ttlAgentLoaded = false;
    }
}

