/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

final class TtlAgentHelper {
    static boolean isBooleanOptionSet(@Nullable Map<String, String> kvs, @NonNull String key, boolean defaultValueIfKeyAbsent) {
        return TtlAgentHelper.isBooleanOptionSet(kvs, key, defaultValueIfKeyAbsent, true);
    }

    static boolean isBooleanOptionSet(@Nullable Map<String, String> kvs, @NonNull String key, boolean defaultValueIfKeyAbsent, boolean defaultValueIfValueAbsent) {
        String value;
        Properties properties = System.getProperties();
        if (properties.containsKey(key)) {
            value = properties.getProperty(key).trim();
        } else {
            if (kvs == null) {
                return defaultValueIfKeyAbsent;
            }
            boolean containsKey = kvs.containsKey(key);
            if (!containsKey) {
                return defaultValueIfKeyAbsent;
            }
            value = kvs.get(key).trim();
        }
        if (value.isEmpty()) {
            return defaultValueIfValueAbsent;
        }
        return !"false".equalsIgnoreCase(value);
    }

    @NonNull
    static String getStringOptionValue(@Nullable Map<String, String> kvs, @NonNull String key, @NonNull String defaultValue) {
        String value;
        Properties properties = System.getProperties();
        if (properties.containsKey(key)) {
            value = properties.getProperty(key).trim();
        } else {
            if (kvs == null) {
                return defaultValue;
            }
            boolean containsKey = kvs.containsKey(key);
            if (!containsKey) {
                return defaultValue;
            }
            value = kvs.get(key).trim();
        }
        if (value.isEmpty()) {
            return defaultValue;
        }
        return value;
    }

    @NonNull
    static List<String> getOptionStringListValues(@Nullable Map<String, String> kvs, @NonNull String key) {
        String value;
        Properties properties = System.getProperties();
        if (properties.containsKey(key)) {
            value = properties.getProperty(key);
        } else {
            if (kvs == null) {
                return Collections.EMPTY_LIST;
            }
            value = kvs.get(key);
        }
        return TtlAgentHelper.splitListStringToStringList(value);
    }

    @NonNull
    static Map<String, String> splitCommaColonStringToKV(@Nullable String commaColonString) {
        String[] splitKvArray;
        HashMap<String, String> ret = new HashMap<String, String>();
        if (commaColonString == null || commaColonString.trim().length() == 0) {
            return ret;
        }
        for (String kvString : splitKvArray = commaColonString.trim().split("\\s*,\\s*")) {
            String[] kv = kvString.trim().split("\\s*:\\s*");
            if (kv.length == 0) continue;
            if (kv.length == 1) {
                ret.put(kv[0], "");
                continue;
            }
            ret.put(kv[0], kv[1]);
        }
        return ret;
    }

    @NonNull
    static List<String> splitListStringToStringList(@Nullable String listString) {
        String[] split;
        ArrayList<String> ret = new ArrayList<String>();
        if (listString == null || listString.trim().length() == 0) {
            return ret;
        }
        for (String s : split = listString.trim().split("\\s*\\|\\s*")) {
            if (s.length() == 0) continue;
            ret.add(s);
        }
        return ret;
    }

    private TtlAgentHelper() {
        throw new InstantiationError("Must not instantiate this class");
    }
}

