/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent;

import com.alibaba.ttl.threadpool.agent.logging.Logger;
import com.alibaba.ttl.threadpool.agent.transformlet.ClassInfo;
import com.alibaba.ttl.threadpool.agent.transformlet.TtlTransformlet;
import com.alibaba.ttl.threadpool.agent.transformlet.helper.TtlTransformletHelper;
import com.alibaba.ttl.threadpool.agent.transformlet.javassist.CannotCompileException;
import com.alibaba.ttl.threadpool.agent.transformlet.javassist.NotFoundException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

final class TtlExtensionTransformletManager {
    private static final Logger logger = Logger.getLogger(TtlExtensionTransformletManager.class);
    private static final String TTL_AGENT_EXTENSION_TRANSFORMLET_FILE = "META-INF/ttl.agent.transformlets";
    private final WeakHashMap<ClassLoader, ?> collectedClassLoaderHistory = new WeakHashMap(512);
    private final WeakHashMap<ClassLoader, Map<String, TtlTransformlet>> classLoader2ExtensionTransformlets = new WeakHashMap(512);
    private final WeakHashMap<ClassLoader, Map<String, TtlTransformlet>> classLoader2ExtensionTransformletsIncludeParentCL = new WeakHashMap(512);
    private final Map<String, LinkedHashSet<String>> redExtensionTransformletFileHistory = new HashMap<String, LinkedHashSet<String>>();

    public String extensionTransformletDoTransform(@NonNull ClassInfo classInfo) throws NotFoundException, CannotCompileException, IOException {
        Map<String, TtlTransformlet> transformlets = this.classLoader2ExtensionTransformletsIncludeParentCL.get(classInfo.getClassLoader());
        if (transformlets == null) {
            return null;
        }
        for (Map.Entry<String, TtlTransformlet> entry : transformlets.entrySet()) {
            String className = entry.getKey();
            TtlTransformlet transformlet = entry.getValue();
            transformlet.doTransform(classInfo);
            if (!classInfo.isModified()) continue;
            return className;
        }
        return null;
    }

    public void collectExtensionTransformlet(@NonNull ClassInfo classInfo) throws IOException {
        ClassLoader classLoader = classInfo.getClassLoader();
        if (classLoader == null) {
            return;
        }
        if (this.collectedClassLoaderHistory.containsKey(classLoader)) {
            return;
        }
        this.collectedClassLoaderHistory.put(classLoader, null);
        logger.info("[TtlExtensionTransformletCollector] collecting TTL Extension Transformlets from classloader " + classLoader);
        LinkedHashSet<String> extensionTransformletClassNames = this.readExtensionTransformletClassNames(classLoader);
        String foundMsgHead = "[TtlExtensionTransformletCollector] found TTL Extension Transformlet class ";
        String failLoadMsgHead = "[TtlExtensionTransformletCollector] fail to load TTL Extension Transformlet ";
        Map<ClassLoader, Set<TtlTransformlet>> loadedTransformlet = TtlExtensionTransformletManager.loadExtensionInstances(classLoader, extensionTransformletClassNames, TtlTransformlet.class, "[TtlExtensionTransformletCollector] found TTL Extension Transformlet class ", "[TtlExtensionTransformletCollector] fail to load TTL Extension Transformlet ");
        TtlExtensionTransformletManager.mergeToClassLoader2ExtensionTransformlet(this.classLoader2ExtensionTransformlets, loadedTransformlet);
        TtlExtensionTransformletManager.updateClassLoader2ExtensionTransformletsIncludeParentCL(this.classLoader2ExtensionTransformlets, this.classLoader2ExtensionTransformletsIncludeParentCL);
    }

    private LinkedHashSet<String> readExtensionTransformletClassNames(ClassLoader classLoader) throws IOException {
        Enumeration<URL> extensionFiles = classLoader.getResources(TTL_AGENT_EXTENSION_TRANSFORMLET_FILE);
        Pair<LinkedHashSet<String>, Set<String>> pair = TtlExtensionTransformletManager.readLinesFromExtensionFiles(extensionFiles, this.redExtensionTransformletFileHistory);
        LinkedHashSet extensionTransformletClassNames = (LinkedHashSet)pair.first;
        Set stringUrls = (Set)pair.second;
        if (!stringUrls.isEmpty()) {
            logger.info("[TtlExtensionTransformletCollector] found TTL Extension Transformlet configuration files from classloader " + classLoader + " : " + stringUrls);
        }
        return extensionTransformletClassNames;
    }

    private static void mergeToClassLoader2ExtensionTransformlet(Map<ClassLoader, Map<String, TtlTransformlet>> destination, Map<ClassLoader, Set<TtlTransformlet>> loadedTransformlets) {
        for (Map.Entry<ClassLoader, Set<TtlTransformlet>> entry : loadedTransformlets.entrySet()) {
            ClassLoader classLoader = entry.getKey();
            Set<TtlTransformlet> transformlets = entry.getValue();
            Map<String, TtlTransformlet> className2Transformlets = destination.get(classLoader);
            if (className2Transformlets == null) {
                className2Transformlets = new HashMap<String, TtlTransformlet>();
                destination.put(classLoader, className2Transformlets);
            }
            for (TtlTransformlet t : transformlets) {
                String className = t.getClass().getName();
                if (className2Transformlets.containsKey(className)) continue;
                className2Transformlets.put(className, t);
                logger.info("[TtlExtensionTransformletCollector] add TTL Extension Transformlet " + className + " success");
            }
        }
    }

    static void updateClassLoader2ExtensionTransformletsIncludeParentCL(Map<ClassLoader, Map<String, TtlTransformlet>> classLoader2ExtensionTransformlets, Map<ClassLoader, Map<String, TtlTransformlet>> classLoader2ExtensionTransformletsIncludeParentCL) {
        for (Map.Entry<ClassLoader, Map<String, TtlTransformlet>> entry : classLoader2ExtensionTransformlets.entrySet()) {
            ClassLoader classLoader = entry.getKey();
            Map<String, TtlTransformlet> merged = TtlExtensionTransformletManager.childClassLoaderFirstMergeTransformlets(classLoader2ExtensionTransformlets, classLoader);
            classLoader2ExtensionTransformletsIncludeParentCL.put(classLoader, merged);
        }
    }

    static Map<String, TtlTransformlet> childClassLoaderFirstMergeTransformlets(Map<ClassLoader, Map<String, TtlTransformlet>> classLoader2Transformlet, ClassLoader classLoader) {
        HashMap<String, TtlTransformlet> ret = new HashMap<String, TtlTransformlet>();
        ArrayDeque<ClassLoader> chain = new ArrayDeque<ClassLoader>();
        chain.add(classLoader);
        while (classLoader.getParent() != null) {
            classLoader = classLoader.getParent();
            chain.addFirst(classLoader);
        }
        for (ClassLoader loader : chain) {
            Map<String, TtlTransformlet> m = classLoader2Transformlet.get(loader);
            if (m == null) continue;
            ret.putAll(m);
        }
        return ret;
    }

    static <T> Map<ClassLoader, Set<T>> loadExtensionInstances(ClassLoader classLoader, LinkedHashSet<String> instanceClassNames, Class<T> superType, String foundMsgHead, String failLoadMsgHead) {
        HashMap<ClassLoader, Set<T>> ret = new HashMap<ClassLoader, Set<T>>();
        for (String className : instanceClassNames) {
            String msg;
            try {
                Class<?> clazz = classLoader.loadClass(className);
                if (!superType.isAssignableFrom(clazz)) {
                    msg = foundMsgHead + className + " from classloader " + classLoader + " at location " + TtlTransformletHelper.getLocationUrlOfClass(clazz) + ", but NOT subtype of " + superType.getName() + ", ignored!";
                    logger.error(msg);
                    continue;
                }
                Object instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ClassLoader actualClassLoader = instance.getClass().getClassLoader();
                HashSet<T> set = (HashSet<T>)ret.get(actualClassLoader);
                if (set == null) {
                    set = new HashSet<T>();
                    ret.put(actualClassLoader, set);
                }
                set.add(superType.cast(instance));
                String msg2 = foundMsgHead + className + ", and loaded from classloader " + classLoader + " at location " + TtlTransformletHelper.getLocationUrlOfClass(clazz);
                logger.info(msg2);
            }
            catch (ClassNotFoundException e) {
                msg = failLoadMsgHead + className + " from classloader " + classLoader + ", cause: " + e.toString();
                logger.warn(msg, e);
            }
            catch (IllegalAccessException e) {
                msg = failLoadMsgHead + className + " from classloader " + classLoader + ", cause: " + e.toString();
                logger.error(msg, e);
            }
            catch (InstantiationException e) {
                msg = failLoadMsgHead + className + " from classloader " + classLoader + ", cause: " + e.toString();
                logger.error(msg, e);
            }
            catch (NoSuchMethodException e) {
                msg = failLoadMsgHead + className + " from classloader " + classLoader + ", cause: " + e.toString();
                logger.error(msg, e);
            }
            catch (InvocationTargetException e) {
                msg = failLoadMsgHead + className + " from classloader " + classLoader + ", cause: " + e.toString();
                logger.error(msg, e);
            }
        }
        return ret;
    }

    @NonNull
    static Pair<LinkedHashSet<String>, Set<String>> readLinesFromExtensionFiles(@NonNull Enumeration<URL> extensionFiles, @NonNull Map<String, LinkedHashSet<String>> redExtensionFilesHistory) {
        LinkedHashSet<String> mergedLines = new LinkedHashSet<String>();
        HashSet<String> stringUrls = new HashSet<String>();
        while (extensionFiles.hasMoreElements()) {
            LinkedHashSet<String> lines;
            URL url = extensionFiles.nextElement();
            String urlString = url.toString();
            stringUrls.add(urlString);
            if (redExtensionFilesHistory.containsKey(urlString)) {
                lines = redExtensionFilesHistory.get(urlString);
            } else {
                lines = TtlExtensionTransformletManager.readLines(url);
                redExtensionFilesHistory.put(urlString, lines);
            }
            mergedLines.addAll(lines);
        }
        return new Pair<LinkedHashSet<String>, Set<String>>(mergedLines, stringUrls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LinkedHashSet<String> readLines(URL extensionFile) {
        InputStream inputStream = null;
        BufferedReader reader = null;
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        try {
            inputStream = extensionFile.openStream();
            reader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
            int lineNum = 1;
            while ((lineNum = TtlExtensionTransformletManager.parseLine(extensionFile, reader, lineNum, names)) >= 0) {
            }
        }
        catch (IOException x) {
            logger.error("Error reading configuration file " + extensionFile, x);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException y) {
                logger.warn("Error closing configuration file " + extensionFile, y);
            }
        }
        return names;
    }

    private static int parseLine(URL url, BufferedReader reader, int lineNum, LinkedHashSet<String> names) throws IOException {
        int n;
        String line = reader.readLine();
        if (line == null) {
            return -1;
        }
        int ci = line.indexOf(35);
        if (ci >= 0) {
            line = line.substring(0, ci);
        }
        if ((n = (line = line.trim()).length()) != 0) {
            if (line.indexOf(32) >= 0 || line.indexOf(9) >= 0) {
                logger.error("Illegal syntax " + line + "in configuration file" + url + ", contains space or tab; ignore this line!");
                return lineNum + 1;
            }
            int cp = line.codePointAt(0);
            if (!Character.isJavaIdentifierStart(cp)) {
                logger.error("Illegal extension class name " + line + " in configuration file " + url + "; ignore this line!");
                return lineNum + 1;
            }
            for (int i = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
                cp = line.codePointAt(i);
                if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
                logger.error("Illegal extension class name: " + line + " in configuration file " + url + "; ignore this line!");
                return lineNum + 1;
            }
            names.add(line);
        }
        return lineNum + 1;
    }

    static class Pair<T, U> {
        T first;
        U second;

        public Pair(T first, U second) {
            this.first = first;
            this.second = second;
        }
    }
}

