/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent;

import com.alibaba.ttl.threadpool.agent.TtlExtensionTransformletManager;
import com.alibaba.ttl.threadpool.agent.logging.Logger;
import com.alibaba.ttl.threadpool.agent.transformlet.ClassInfo;
import com.alibaba.ttl.threadpool.agent.transformlet.TtlTransformlet;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;

public class TtlTransformer
implements ClassFileTransformer {
    private static final Logger logger = Logger.getLogger(TtlTransformer.class);
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    private static final byte[] NO_TRANSFORM = null;
    private final TtlExtensionTransformletManager extensionTransformletManager;
    private final List<TtlTransformlet> transformletList = new ArrayList<TtlTransformlet>();
    private final boolean logClassTransform;

    TtlTransformer(List<? extends TtlTransformlet> transformletList, boolean logClassTransform) {
        this.extensionTransformletManager = new TtlExtensionTransformletManager();
        this.logClassTransform = logClassTransform;
        for (TtlTransformlet ttlTransformlet : transformletList) {
            this.transformletList.add(ttlTransformlet);
            logger.info("[TtlTransformer] add Transformlet " + ttlTransformlet.getClass().getName());
        }
    }

    @Override
    public final byte[] transform(@Nullable ClassLoader loader, @Nullable String classFile, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, @NonNull byte[] classFileBuffer) {
        try {
            if (classFile == null) {
                return NO_TRANSFORM;
            }
            ClassInfo classInfo = new ClassInfo(classFile, classFileBuffer, loader);
            if (this.logClassTransform) {
                logger.info("[TtlTransformer] transforming " + classInfo.getClassName() + " from classloader " + classInfo.getClassLoader() + " at location " + classInfo.getLocationUrl());
            }
            this.extensionTransformletManager.collectExtensionTransformlet(classInfo);
            for (TtlTransformlet transformlet : this.transformletList) {
                transformlet.doTransform(classInfo);
                if (!classInfo.isModified()) continue;
                logger.info("[TtlTransformer] " + transformlet.getClass().getName() + " transformed " + classInfo.getClassName() + " from classloader " + classInfo.getClassLoader() + " at location " + classInfo.getLocationUrl());
                return classInfo.getCtClass().toBytecode();
            }
            String transformlet = this.extensionTransformletManager.extensionTransformletDoTransform(classInfo);
            if (classInfo.isModified()) {
                logger.info("[TtlTransformer] " + transformlet + " transformed " + classInfo.getClassName() + " from classloader " + classInfo.getClassLoader() + " at location " + classInfo.getLocationUrl());
                return classInfo.getCtClass().toBytecode();
            }
        }
        catch (Throwable t) {
            String msg = "[TtlTransformer] fail to transform class " + classFile + ", cause: " + t.toString();
            logger.error(msg, t);
            throw new IllegalStateException(msg, t);
        }
        return NO_TRANSFORM;
    }
}

