/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;

public abstract class Logger {
    public static final String STDOUT = "STDOUT";
    public static final String STDERR = "STDERR";
    private static volatile int loggerImplType = -1;
    final Class<?> logClass;

    public static void setLoggerImplType(String type) {
        if (loggerImplType != -1) {
            throw new IllegalStateException("TTL logger implementation type is already set! type = " + loggerImplType);
        }
        loggerImplType = STDERR.equalsIgnoreCase(type) ? 0 : (STDOUT.equalsIgnoreCase(type) ? 1 : 0);
    }

    public static Logger getLogger(Class<?> clazz) {
        if (loggerImplType == -1) {
            throw new IllegalStateException("TTL logger implementation type is NOT set!");
        }
        switch (loggerImplType) {
            case 1: {
                return new StdOutLogger(clazz);
            }
        }
        return new StdErrorLogger(clazz);
    }

    private Logger(Class<?> logClass) {
        this.logClass = logClass;
    }

    public void info(String msg) {
        this.log(Level.INFO, msg, null);
    }

    public void warn(String msg) {
        this.log(Level.WARNING, msg, null);
    }

    public void warn(String msg, Throwable thrown) {
        this.log(Level.WARNING, msg, thrown);
    }

    public void error(String msg) {
        this.log(Level.SEVERE, msg, null);
    }

    public void error(String msg, Throwable thrown) {
        this.log(Level.SEVERE, msg, thrown);
    }

    protected abstract void log(Level var1, String var2, Throwable var3);

    private static class StdOutLogger
    extends Logger {
        StdOutLogger(Class<?> clazz) {
            super(clazz);
        }

        @Override
        public void log(Level level, String msg, Throwable thrown) {
            String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date());
            System.out.printf("%s %s [%s] %s: %s%n", time, level, Thread.currentThread().getName(), this.logClass.getSimpleName(), msg);
            if (thrown != null) {
                thrown.printStackTrace(System.out);
            }
        }
    }

    private static class StdErrorLogger
    extends Logger {
        StdErrorLogger(Class<?> clazz) {
            super(clazz);
        }

        @Override
        public void log(Level level, String msg, Throwable thrown) {
            if (level == Level.SEVERE) {
                String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date());
                System.err.printf("%s %s [%s] %s: %s%n", time, level, Thread.currentThread().getName(), this.logClass.getSimpleName(), msg);
                if (thrown != null) {
                    thrown.printStackTrace();
                }
            }
        }
    }
}

