/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.transformlet;

import com.alibaba.ttl.threadpool.agent.transformlet.helper.TtlTransformletHelper;
import com.alibaba.ttl.threadpool.agent.transformlet.javassist.ClassPool;
import com.alibaba.ttl.threadpool.agent.transformlet.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.transformlet.javassist.LoaderClassPath;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;

public class ClassInfo {
    private final String transformerClassFile;
    private final String className;
    private final byte[] classFileBuffer;
    private final ClassLoader loader;
    private CtClass ctClass;
    private boolean modified = false;

    public ClassInfo(@NonNull String transformerClassFile, @NonNull @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}) byte[] classFileBuffer, @Nullable ClassLoader loader) {
        this.transformerClassFile = transformerClassFile;
        this.className = ClassInfo.toClassName(transformerClassFile);
        this.classFileBuffer = classFileBuffer;
        this.loader = loader;
    }

    @NonNull
    public String getClassName() {
        return this.className;
    }

    public URL getLocationUrl() throws IOException {
        return TtlTransformletHelper.getLocationUrlOfClass(this.getCtClass());
    }

    @NonNull
    public CtClass getCtClass() throws IOException {
        if (this.ctClass != null) {
            return this.ctClass;
        }
        ClassPool classPool = new ClassPool(true);
        if (this.loader == null) {
            classPool.appendClassPath(new LoaderClassPath(ClassLoader.getSystemClassLoader()));
        } else {
            classPool.appendClassPath(new LoaderClassPath(this.loader));
        }
        CtClass clazz = classPool.makeClass(new ByteArrayInputStream(this.classFileBuffer), false);
        clazz.defrost();
        this.ctClass = clazz;
        return clazz;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified() {
        this.modified = true;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    private static String toClassName(@NonNull String classFile) {
        return classFile.replace('/', '.');
    }
}

