/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.transformlet.helper;

import com.alibaba.ttl.threadpool.agent.logging.Logger;
import com.alibaba.ttl.threadpool.agent.transformlet.ClassInfo;
import com.alibaba.ttl.threadpool.agent.transformlet.TtlTransformlet;
import com.alibaba.ttl.threadpool.agent.transformlet.helper.TtlTransformletHelper;
import com.alibaba.ttl.threadpool.agent.transformlet.javassist.CannotCompileException;
import com.alibaba.ttl.threadpool.agent.transformlet.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.transformlet.javassist.CtConstructor;
import com.alibaba.ttl.threadpool.agent.transformlet.javassist.CtMethod;
import com.alibaba.ttl.threadpool.agent.transformlet.javassist.NotFoundException;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractExecutorTtlTransformlet
implements TtlTransformlet {
    protected static final String RUNNABLE_CLASS_NAME = "java.lang.Runnable";
    protected static final String CALLABLE_CLASS_NAME = "java.util.concurrent.Callable";
    protected static final String TTL_RUNNABLE_CLASS_NAME = "com.alibaba.ttl.TtlRunnable";
    protected static final String TTL_CALLABLE_CLASS_NAME = "com.alibaba.ttl.TtlCallable";
    protected static final String THREAD_FACTORY_CLASS_NAME = "java.util.concurrent.ThreadFactory";
    protected static final String THREAD_POOL_EXECUTOR_CLASS_NAME = "java.util.concurrent.ThreadPoolExecutor";
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected final Set<String> executorClassNames;
    protected final boolean disableInheritableForThreadPool;
    private final Map<String, String> paramTypeNameToDecorateMethodClass = new HashMap<String, String>();

    public AbstractExecutorTtlTransformlet(Set<String> executorClassNames, boolean disableInheritableForThreadPool) {
        this.executorClassNames = executorClassNames;
        this.disableInheritableForThreadPool = disableInheritableForThreadPool;
        this.paramTypeNameToDecorateMethodClass.put(RUNNABLE_CLASS_NAME, TTL_RUNNABLE_CLASS_NAME);
        this.paramTypeNameToDecorateMethodClass.put(CALLABLE_CLASS_NAME, TTL_CALLABLE_CLASS_NAME);
    }

    @Override
    public final void doTransform(@NonNull ClassInfo classInfo) throws IOException, NotFoundException, CannotCompileException {
        CtClass clazz = classInfo.getCtClass();
        if (this.executorClassNames.contains(classInfo.getClassName())) {
            for (CtMethod method : clazz.getDeclaredMethods()) {
                this.updateSubmitMethodsOfExecutorClass_decorateToTtlWrapperAndSetAutoWrapperAttachment(method);
            }
            if (this.disableInheritableForThreadPool) {
                this.updateConstructorDisableInheritable(clazz);
            }
            classInfo.setModified();
        } else {
            if (clazz.isPrimitive() || clazz.isArray() || clazz.isInterface() || clazz.isAnnotation()) {
                return;
            }
            if (!clazz.subclassOf(clazz.getClassPool().get(THREAD_POOL_EXECUTOR_CLASS_NAME))) {
                return;
            }
            this.logger.info("Transforming class " + classInfo.getClassName());
            boolean modified = this.updateBeforeAndAfterExecuteMethodOfExecutorSubclass(clazz);
            if (modified) {
                classInfo.setModified();
            }
        }
    }

    @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"})
    private void updateSubmitMethodsOfExecutorClass_decorateToTtlWrapperAndSetAutoWrapperAttachment(@NonNull CtMethod method) throws NotFoundException, CannotCompileException {
        int modifiers = method.getModifiers();
        if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers)) {
            return;
        }
        CtClass[] parameterTypes = method.getParameterTypes();
        StringBuilder insertCode = new StringBuilder();
        for (int i = 0; i < parameterTypes.length; ++i) {
            String paramTypeName = parameterTypes[i].getName();
            if (!this.paramTypeNameToDecorateMethodClass.containsKey(paramTypeName)) continue;
            String code = String.format("    $%d = %s.get($%1$d, false, true);\n    com.alibaba.ttl.spi.TtlAttachmentsDelegate.setAutoWrapperAttachment($%1$d);", i + 1, this.paramTypeNameToDecorateMethodClass.get(paramTypeName));
            this.logger.info("insert code before method " + TtlTransformletHelper.signatureOfMethod(method) + " of class " + method.getDeclaringClass().getName() + ":\n" + code);
            insertCode.append(code);
        }
        if (insertCode.length() > 0) {
            method.insertBefore(insertCode.toString());
        }
    }

    private void updateConstructorDisableInheritable(@NonNull CtClass clazz) throws NotFoundException, CannotCompileException {
        for (CtConstructor constructor : clazz.getDeclaredConstructors()) {
            CtClass[] parameterTypes = constructor.getParameterTypes();
            StringBuilder insertCode = new StringBuilder();
            for (int i = 0; i < parameterTypes.length; ++i) {
                String paramTypeName = parameterTypes[i].getName();
                if (!THREAD_FACTORY_CLASS_NAME.equals(paramTypeName)) continue;
                String code = String.format("$%d = com.alibaba.ttl.threadpool.TtlExecutors.getDisableInheritableThreadFactory($%<d);", i + 1);
                this.logger.info("insert code before method " + TtlTransformletHelper.signatureOfMethod(constructor) + " of class " + constructor.getDeclaringClass().getName() + ": " + code);
                insertCode.append(code);
            }
            if (insertCode.length() <= 0) continue;
            constructor.insertBefore(insertCode.toString());
        }
    }

    private boolean updateBeforeAndAfterExecuteMethodOfExecutorSubclass(@NonNull CtClass clazz) throws NotFoundException, CannotCompileException {
        String code;
        CtClass runnableClass = clazz.getClassPool().get(RUNNABLE_CLASS_NAME);
        CtClass threadClass = clazz.getClassPool().get("java.lang.Thread");
        CtClass throwableClass = clazz.getClassPool().get("java.lang.Throwable");
        boolean modified = false;
        try {
            CtMethod beforeExecute = clazz.getDeclaredMethod("beforeExecute", new CtClass[]{threadClass, runnableClass});
            code = "$2 = com.alibaba.ttl.spi.TtlAttachmentsDelegate.unwrapIfIsAutoWrapper($2);";
            this.logger.info("insert code before method " + TtlTransformletHelper.signatureOfMethod(beforeExecute) + " of class " + beforeExecute.getDeclaringClass().getName() + ": " + code);
            beforeExecute.insertBefore(code);
            modified = true;
        }
        catch (NotFoundException beforeExecute) {
            // empty catch block
        }
        try {
            CtMethod afterExecute = clazz.getDeclaredMethod("afterExecute", new CtClass[]{runnableClass, throwableClass});
            code = "$1 = com.alibaba.ttl.spi.TtlAttachmentsDelegate.unwrapIfIsAutoWrapper($1);";
            this.logger.info("insert code before method " + TtlTransformletHelper.signatureOfMethod(afterExecute) + " of class " + afterExecute.getDeclaringClass().getName() + ": " + code);
            afterExecute.insertBefore(code);
            modified = true;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return modified;
    }
}

