/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.transformlet.helper;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.alibaba.ttl.spi.TtlEnhanced;
import com.alibaba.ttl.threadpool.agent.logging.Logger;
import com.alibaba.ttl.threadpool.agent.transformlet.javassist.CannotCompileException;
import com.alibaba.ttl.threadpool.agent.transformlet.javassist.CtBehavior;
import com.alibaba.ttl.threadpool.agent.transformlet.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.transformlet.javassist.CtMethod;
import com.alibaba.ttl.threadpool.agent.transformlet.javassist.CtNewMethod;
import com.alibaba.ttl.threadpool.agent.transformlet.javassist.NotFoundException;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;

public final class TtlTransformletHelper {
    private static final Logger logger = Logger.getLogger(TtlTransformletHelper.class);

    @NonNull
    public static String signatureOfMethod(@NonNull CtBehavior method) throws NotFoundException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Modifier.toString(method.getModifiers()));
        if (method instanceof CtMethod) {
            String returnType = ((CtMethod)method).getReturnType().getSimpleName();
            stringBuilder.append(" ").append(returnType);
        }
        stringBuilder.append(" ").append(method.getName()).append("(");
        CtClass[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            CtClass parameterType = parameterTypes[i];
            if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(parameterType.getSimpleName());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static URL getLocationUrlOfClass(CtClass clazz) {
        try {
            if (clazz.getName().startsWith("com.sun.proxy.")) {
                return null;
            }
            return clazz.getURL();
        }
        catch (Exception e) {
            logger.warn("Fail to getLocationUrlOfClass " + clazz.getName() + ", cause: " + e.toString());
            return null;
        }
    }

    public static String getLocationFileOfClass(CtClass clazz) {
        URL location = TtlTransformletHelper.getLocationUrlOfClass(clazz);
        if (location == null) {
            return null;
        }
        return location.getFile();
    }

    public static URL getLocationUrlOfClass(Class<?> clazz) {
        try {
            if (clazz.getName().startsWith("com.sun.proxy.")) {
                return null;
            }
            ProtectionDomain protectionDomain = clazz.getProtectionDomain();
            if (protectionDomain == null) {
                return null;
            }
            CodeSource codeSource = protectionDomain.getCodeSource();
            if (codeSource == null) {
                return null;
            }
            return codeSource.getLocation();
        }
        catch (Exception e) {
            logger.warn("Fail to getLocationUrlOfClass " + clazz.getName() + ", cause: " + e.toString());
            return null;
        }
    }

    public static String getLocationFileOfClass(Class<?> clazz) {
        URL location = TtlTransformletHelper.getLocationUrlOfClass(clazz);
        if (location == null) {
            return null;
        }
        return location.getFile();
    }

    @NonNull
    public static String renamedMethodNameByTtl(@NonNull CtMethod method) {
        return "original$" + method.getName() + "$method$renamed$by$ttl";
    }

    public static String addTryFinallyToMethod(@NonNull CtMethod method, @NonNull String beforeCode, @NonNull String finallyCode) throws CannotCompileException, NotFoundException {
        return TtlTransformletHelper.addTryFinallyToMethod(method, TtlTransformletHelper.renamedMethodNameByTtl(method), beforeCode, finallyCode);
    }

    public static String addTryFinallyToMethod(@NonNull CtMethod method, @NonNull String nameForOriginalMethod, @NonNull String beforeCode, @NonNull String finallyCode) throws CannotCompileException, NotFoundException {
        CtClass clazz = method.getDeclaringClass();
        CtMethod newMethod = CtNewMethod.copy(method, clazz, null);
        newMethod.setName(nameForOriginalMethod);
        newMethod.setModifiers(newMethod.getModifiers() & 0xFFFFFFFE & 0xFFFFFFFB | 2);
        clazz.addMethod(newMethod);
        String returnOp = method.getReturnType() == CtClass.voidType ? "" : "return ";
        String code = "{\n" + beforeCode + "\ntry {\n    " + returnOp + nameForOriginalMethod + "($$);\n} finally {\n    " + finallyCode + "\n} }";
        method.setBody(code);
        return code;
    }

    @Nullable
    public static Object doCaptureIfNotTtlEnhanced(@Nullable Object obj) {
        if (obj instanceof TtlEnhanced) {
            return null;
        }
        return TransmittableThreadLocal.Transmitter.capture();
    }

    private TtlTransformletHelper() {
        throw new InstantiationError("Must not instantiate this class");
    }
}

