/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.transformlet.internal;

import com.alibaba.ttl.threadpool.agent.logging.Logger;
import com.alibaba.ttl.threadpool.agent.transformlet.ClassInfo;
import com.alibaba.ttl.threadpool.agent.transformlet.TtlTransformlet;
import com.alibaba.ttl.threadpool.agent.transformlet.helper.TtlTransformletHelper;
import com.alibaba.ttl.threadpool.agent.transformlet.javassist.CannotCompileException;
import com.alibaba.ttl.threadpool.agent.transformlet.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.transformlet.javassist.CtField;
import com.alibaba.ttl.threadpool.agent.transformlet.javassist.CtMethod;
import com.alibaba.ttl.threadpool.agent.transformlet.javassist.NotFoundException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class TimerTaskTtlTransformlet
implements TtlTransformlet {
    private static final Logger logger = Logger.getLogger(TimerTaskTtlTransformlet.class);
    private static final String TIMER_TASK_CLASS_NAME = "java.util.TimerTask";
    private static final String RUN_METHOD_NAME = "run";

    @Override
    public void doTransform(@NonNull ClassInfo classInfo) throws IOException, NotFoundException, CannotCompileException {
        if (TIMER_TASK_CLASS_NAME.equals(classInfo.getClassName())) {
            return;
        }
        CtClass clazz = classInfo.getCtClass();
        if (clazz.isPrimitive() || clazz.isArray() || clazz.isInterface() || clazz.isAnnotation()) {
            return;
        }
        try {
            CtMethod runMethod = clazz.getDeclaredMethod(RUN_METHOD_NAME, new CtClass[0]);
            if (!CtClass.voidType.equals(runMethod.getReturnType())) {
                return;
            }
        }
        catch (NotFoundException e) {
            return;
        }
        if (!clazz.subclassOf(clazz.getClassPool().get(TIMER_TASK_CLASS_NAME))) {
            return;
        }
        logger.info("Transforming class " + classInfo.getClassName());
        this.updateTimerTaskClass(clazz);
        classInfo.setModified();
    }

    private void updateTimerTaskClass(@NonNull CtClass clazz) throws CannotCompileException, NotFoundException {
        String className = clazz.getName();
        String capturedFieldName = "captured$field$added$by$ttl";
        CtField capturedField = CtField.make("private final Object captured$field$added$by$ttl;", clazz);
        clazz.addField(capturedField, "com.alibaba.ttl.threadpool.agent.transformlet.helper.TtlTransformletHelper.doCaptureIfNotTtlEnhanced(this);");
        logger.info("add new field captured$field$added$by$ttl to class " + className);
        CtMethod runMethod = clazz.getDeclaredMethod(RUN_METHOD_NAME, new CtClass[0]);
        String beforeCode = "Object backup = com.alibaba.ttl.TransmittableThreadLocal.Transmitter.replay(captured$field$added$by$ttl);";
        String finallyCode = "com.alibaba.ttl.TransmittableThreadLocal.Transmitter.restore(backup);";
        String code = TtlTransformletHelper.addTryFinallyToMethod(runMethod, "Object backup = com.alibaba.ttl.TransmittableThreadLocal.Transmitter.replay(captured$field$added$by$ttl);", "com.alibaba.ttl.TransmittableThreadLocal.Transmitter.restore(backup);");
        logger.info("insert code around method " + TtlTransformletHelper.signatureOfMethod(runMethod) + " of class " + clazz.getName() + ": " + code);
    }
}

