/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.method;

import com.alicp.jetcache.CacheException;
import com.alicp.jetcache.anno.method.CacheInvokeContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.function.Function;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

class SpelEvaluator
implements Function<Object, Object> {
    private static ExpressionParser parser;
    private static ParameterNameDiscoverer parameterNameDiscoverer;
    private final Expression expression;
    private String[] parameterNames;

    public SpelEvaluator(String script, Method defineMethod) {
        this.expression = parser.parseExpression(script);
        if (defineMethod.getParameterCount() > 0) {
            this.parameterNames = parameterNameDiscoverer.getParameterNames(defineMethod);
        }
    }

    @Override
    public Object apply(Object rootObject) {
        StandardEvaluationContext context = new StandardEvaluationContext(rootObject);
        CacheInvokeContext cic = (CacheInvokeContext)rootObject;
        if (this.parameterNames != null) {
            for (int i = 0; i < this.parameterNames.length; ++i) {
                context.setVariable(this.parameterNames[i], cic.getArgs()[i]);
            }
        }
        context.setVariable("result", cic.getResult());
        return this.expression.getValue((EvaluationContext)context);
    }

    static {
        try {
            Class<?> modeClass = Class.forName("org.springframework.expression.spel.SpelCompilerMode");
            try {
                Constructor c = SpelParserConfiguration.class.getConstructor(modeClass, ClassLoader.class);
                Object mode = modeClass.getField("IMMEDIATE").get(null);
                SpelParserConfiguration config = (SpelParserConfiguration)c.newInstance(mode, SpelEvaluator.class.getClassLoader());
                parser = new SpelExpressionParser(config);
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
        catch (ClassNotFoundException e) {
            parser = new SpelExpressionParser();
        }
        parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    }
}

