/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.support;

import com.alicp.jetcache.Cache;
import com.alicp.jetcache.anno.support.CacheManager;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCacheManager
implements CacheManager {
    private static final Logger logger = LoggerFactory.getLogger(SimpleCacheManager.class);
    private ConcurrentHashMap<String, ConcurrentHashMap<String, Cache>> caches = new ConcurrentHashMap();
    private BiFunction<String, String, Cache> cacheCreator;
    static SimpleCacheManager defaultManager = new SimpleCacheManager();

    public void rebuild() {
        this.caches.forEach((area, areaMap) -> areaMap.forEach((cacheName, cache) -> {
            try {
                cache.close();
            }
            catch (Exception e) {
                logger.error("error during close", (Throwable)e);
            }
        }));
        this.caches.clear();
        this.cacheCreator = null;
    }

    private ConcurrentHashMap<String, Cache> getCachesByArea(String area) {
        return this.caches.computeIfAbsent(area, key -> new ConcurrentHashMap());
    }

    @Override
    public Cache getCache(String area, String cacheName) {
        ConcurrentHashMap<String, Cache> areaMap = this.getCachesByArea(area);
        Cache c = areaMap.get(cacheName);
        if (c == null && this.cacheCreator != null) {
            return this.cacheCreator.apply(area, cacheName);
        }
        return c;
    }

    public Cache getCacheWithoutCreate(String area, String cacheName) {
        ConcurrentHashMap<String, Cache> areaMap = this.getCachesByArea(area);
        return areaMap.get(cacheName);
    }

    public void putCache(String area, String cacheName, Cache cache) {
        ConcurrentHashMap<String, Cache> areaMap = this.getCachesByArea(area);
        areaMap.put(cacheName, cache);
    }

    public void setCacheCreator(BiFunction<String, String, Cache> cacheCreator) {
        this.cacheCreator = cacheCreator;
    }
}

