/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.autoconfigure;

import com.alicp.jetcache.autoconfigure.AutoConfigureBeans;
import com.lambdaworks.redis.AbstractRedisClient;
import com.lambdaworks.redis.api.StatefulConnection;
import com.lambdaworks.redis.cluster.api.async.RedisClusterAsyncCommands;
import com.lambdaworks.redis.cluster.api.rx.RedisClusterReactiveCommands;
import com.lambdaworks.redis.cluster.api.sync.RedisClusterCommands;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;

public class Lettuce4Factory
implements FactoryBean {
    @Autowired
    private AutoConfigureBeans autoConfigureBeans;
    private boolean inited;
    private Object obj;
    private Class<?> clazz;
    private String key;

    Lettuce4Factory(AutoConfigureBeans autoConfigureBeans, String key, Class<?> clazz) {
        this(key, clazz);
        this.autoConfigureBeans = autoConfigureBeans;
    }

    public Lettuce4Factory(String key, Class<?> clazz) {
        this.clazz = clazz;
        if (AbstractRedisClient.class.isAssignableFrom(clazz)) {
            key = key + ".client";
        } else if (StatefulConnection.class.isAssignableFrom(clazz)) {
            key = key + ".connection";
        } else if (RedisClusterCommands.class.isAssignableFrom(clazz)) {
            key = key + ".commands";
        } else if (RedisClusterAsyncCommands.class.isAssignableFrom(clazz)) {
            key = key + ".asyncCommands";
        } else if (RedisClusterReactiveCommands.class.isAssignableFrom(clazz)) {
            key = key + ".reactiveCommands";
        } else {
            throw new IllegalArgumentException(clazz.getName());
        }
        this.key = key;
    }

    private void init() {
        if (!this.inited) {
            this.obj = this.autoConfigureBeans.getCustomContainer().get(this.key);
            this.inited = true;
        }
    }

    public Object getObject() throws Exception {
        this.init();
        return this.obj;
    }

    public Class<?> getObjectType() {
        return this.clazz;
    }

    public boolean isSingleton() {
        return true;
    }
}

