/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.autoconfigure;

import com.alicp.jetcache.CacheBuilder;
import com.alicp.jetcache.autoconfigure.ConfigTree;
import com.alicp.jetcache.autoconfigure.ExternalCacheAutoInit;
import com.alicp.jetcache.autoconfigure.JetCacheCondition;
import com.alicp.jetcache.external.MockRemoteCacheBuilder;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={MockRemoteCacheCondition.class})
public class MockRemoteCacheAutoConfiguration
extends ExternalCacheAutoInit {
    public MockRemoteCacheAutoConfiguration() {
        super("mock");
    }

    @Override
    protected CacheBuilder initCache(ConfigTree ct, String cacheAreaWithPrefix) {
        MockRemoteCacheBuilder.MockRemoteCacheBuilderImpl builder = MockRemoteCacheBuilder.createMockRemoteCacheBuilder();
        this.parseGeneralConfig((CacheBuilder)builder, ct);
        return builder;
    }

    @Override
    protected void parseGeneralConfig(CacheBuilder builder, ConfigTree ct) {
        super.parseGeneralConfig(builder, ct);
        MockRemoteCacheBuilder b = (MockRemoteCacheBuilder)builder;
        b.limit(Integer.parseInt(ct.getProperty("limit", String.valueOf(100))));
    }

    public static class MockRemoteCacheCondition
    extends JetCacheCondition {
        public MockRemoteCacheCondition() {
            super("mock");
        }
    }
}

