/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.easysdk.payment.common;

import com.alipay.easysdk.payment.common.models.AlipayDataDataserviceBillDownloadurlQueryResponse;
import com.alipay.easysdk.payment.common.models.AlipayTradeCancelResponse;
import com.alipay.easysdk.payment.common.models.AlipayTradeCloseResponse;
import com.alipay.easysdk.payment.common.models.AlipayTradeCreateResponse;
import com.alipay.easysdk.payment.common.models.AlipayTradeFastpayRefundQueryResponse;
import com.alipay.easysdk.payment.common.models.AlipayTradeQueryResponse;
import com.alipay.easysdk.payment.common.models.AlipayTradeRefundResponse;
import com.aliyun.tea.Tea;
import com.aliyun.tea.TeaConverter;
import com.aliyun.tea.TeaException;
import com.aliyun.tea.TeaModel;
import com.aliyun.tea.TeaPair;
import com.aliyun.tea.TeaRequest;
import com.aliyun.tea.TeaResponse;
import com.aliyun.tea.TeaUnretryableException;
import java.util.HashMap;
import java.util.Map;

public class Client {
    public com.alipay.easysdk.kernel.Client _kernel;

    public Client(com.alipay.easysdk.kernel.Client kernel) throws Exception {
        this._kernel = kernel;
    }

    public AlipayTradeCreateResponse create(String subject, String outTradeNo, String totalAmount, String buyerId) throws Exception {
        Map<String, Object> runtime_ = TeaConverter.buildMap(new TeaPair("connectTimeout", 15000), new TeaPair("readTimeout", 15000), new TeaPair("retry", TeaConverter.buildMap(new TeaPair("maxAttempts", 0))));
        TeaRequest _lastRequest = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)runtime_.get("retry"), _retryTimes, _now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), _retryTimes)) > 0) {
                Tea.sleep(backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                Map<String, String> systemParams = TeaConverter.buildMap(new TeaPair("method", "alipay.trade.create"), new TeaPair("app_id", this._kernel.getConfig("appId")), new TeaPair("timestamp", this._kernel.getTimestamp()), new TeaPair("format", "json"), new TeaPair("version", "1.0"), new TeaPair("alipay_sdk", this._kernel.getSdkVersion()), new TeaPair("charset", "UTF-8"), new TeaPair("sign_type", this._kernel.getConfig("signType")), new TeaPair("app_cert_sn", this._kernel.getMerchantCertSN()), new TeaPair("alipay_root_cert_sn", this._kernel.getAlipayRootCertSN()));
                Map bizParams = TeaConverter.buildMap(new TeaPair("subject", subject), new TeaPair("out_trade_no", outTradeNo), new TeaPair("total_amount", totalAmount), new TeaPair("buyer_id", buyerId));
                HashMap<String, String> textParams = new HashMap<String, String>();
                request_.protocol = this._kernel.getConfig("protocol");
                request_.method = "POST";
                request_.pathname = "/gateway.do";
                request_.headers = TeaConverter.buildMap(new TeaPair("host", this._kernel.getConfig("gatewayHost")), new TeaPair("content-type", "application/x-www-form-urlencoded;charset=utf-8"));
                request_.query = this._kernel.sortMap(TeaConverter.merge(String.class, TeaConverter.buildMap(new TeaPair("sign", this._kernel.sign(systemParams, bizParams, textParams, this._kernel.getConfig("merchantPrivateKey")))), systemParams, textParams));
                request_.body = Tea.toReadable(this._kernel.toUrlEncodedRequestBody(bizParams));
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction(request_, runtime_);
                Map<String, Object> respMap = this._kernel.readAsJson(response_, "alipay.trade.create");
                if (this._kernel.isCertMode() != false ? this._kernel.verify(respMap, this._kernel.extractAlipayPublicKey(this._kernel.getAlipayCertSN(respMap))) != false : this._kernel.verify(respMap, this._kernel.getConfig("alipayPublicKey")) != false) {
                    return TeaModel.toModel(this._kernel.toRespModel(respMap), new AlipayTradeCreateResponse());
                }
                throw new TeaException(TeaConverter.buildMap(new TeaPair("message", "\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u652f\u4ed8\u5b9d\u516c\u94a5\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002")));
            }
            catch (Exception e) {
                if (Tea.isRetryable(e)) continue;
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest);
    }

    public AlipayTradeQueryResponse query(String outTradeNo) throws Exception {
        Map<String, Object> runtime_ = TeaConverter.buildMap(new TeaPair("connectTimeout", 15000), new TeaPair("readTimeout", 15000), new TeaPair("retry", TeaConverter.buildMap(new TeaPair("maxAttempts", 0))));
        TeaRequest _lastRequest = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)runtime_.get("retry"), _retryTimes, _now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), _retryTimes)) > 0) {
                Tea.sleep(backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                Map<String, String> systemParams = TeaConverter.buildMap(new TeaPair("method", "alipay.trade.query"), new TeaPair("app_id", this._kernel.getConfig("appId")), new TeaPair("timestamp", this._kernel.getTimestamp()), new TeaPair("format", "json"), new TeaPair("version", "1.0"), new TeaPair("alipay_sdk", this._kernel.getSdkVersion()), new TeaPair("charset", "UTF-8"), new TeaPair("sign_type", this._kernel.getConfig("signType")), new TeaPair("app_cert_sn", this._kernel.getMerchantCertSN()), new TeaPair("alipay_root_cert_sn", this._kernel.getAlipayRootCertSN()));
                Map bizParams = TeaConverter.buildMap(new TeaPair("out_trade_no", outTradeNo));
                HashMap<String, String> textParams = new HashMap<String, String>();
                request_.protocol = this._kernel.getConfig("protocol");
                request_.method = "POST";
                request_.pathname = "/gateway.do";
                request_.headers = TeaConverter.buildMap(new TeaPair("host", this._kernel.getConfig("gatewayHost")), new TeaPair("content-type", "application/x-www-form-urlencoded;charset=utf-8"));
                request_.query = this._kernel.sortMap(TeaConverter.merge(String.class, TeaConverter.buildMap(new TeaPair("sign", this._kernel.sign(systemParams, bizParams, textParams, this._kernel.getConfig("merchantPrivateKey")))), systemParams, textParams));
                request_.body = Tea.toReadable(this._kernel.toUrlEncodedRequestBody(bizParams));
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction(request_, runtime_);
                Map<String, Object> respMap = this._kernel.readAsJson(response_, "alipay.trade.query");
                if (this._kernel.isCertMode() != false ? this._kernel.verify(respMap, this._kernel.extractAlipayPublicKey(this._kernel.getAlipayCertSN(respMap))) != false : this._kernel.verify(respMap, this._kernel.getConfig("alipayPublicKey")) != false) {
                    return TeaModel.toModel(this._kernel.toRespModel(respMap), new AlipayTradeQueryResponse());
                }
                throw new TeaException(TeaConverter.buildMap(new TeaPair("message", "\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u652f\u4ed8\u5b9d\u516c\u94a5\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002")));
            }
            catch (Exception e) {
                if (Tea.isRetryable(e)) continue;
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest);
    }

    public AlipayTradeRefundResponse refund(String outTradeNo, String refundAmount) throws Exception {
        Map<String, Object> runtime_ = TeaConverter.buildMap(new TeaPair("connectTimeout", 15000), new TeaPair("readTimeout", 15000), new TeaPair("retry", TeaConverter.buildMap(new TeaPair("maxAttempts", 0))));
        TeaRequest _lastRequest = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)runtime_.get("retry"), _retryTimes, _now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), _retryTimes)) > 0) {
                Tea.sleep(backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                Map<String, String> systemParams = TeaConverter.buildMap(new TeaPair("method", "alipay.trade.refund"), new TeaPair("app_id", this._kernel.getConfig("appId")), new TeaPair("timestamp", this._kernel.getTimestamp()), new TeaPair("format", "json"), new TeaPair("version", "1.0"), new TeaPair("alipay_sdk", this._kernel.getSdkVersion()), new TeaPair("charset", "UTF-8"), new TeaPair("sign_type", this._kernel.getConfig("signType")), new TeaPair("app_cert_sn", this._kernel.getMerchantCertSN()), new TeaPair("alipay_root_cert_sn", this._kernel.getAlipayRootCertSN()));
                Map bizParams = TeaConverter.buildMap(new TeaPair("out_trade_no", outTradeNo), new TeaPair("refund_amount", refundAmount));
                HashMap<String, String> textParams = new HashMap<String, String>();
                request_.protocol = this._kernel.getConfig("protocol");
                request_.method = "POST";
                request_.pathname = "/gateway.do";
                request_.headers = TeaConverter.buildMap(new TeaPair("host", this._kernel.getConfig("gatewayHost")), new TeaPair("content-type", "application/x-www-form-urlencoded;charset=utf-8"));
                request_.query = this._kernel.sortMap(TeaConverter.merge(String.class, TeaConverter.buildMap(new TeaPair("sign", this._kernel.sign(systemParams, bizParams, textParams, this._kernel.getConfig("merchantPrivateKey")))), systemParams, textParams));
                request_.body = Tea.toReadable(this._kernel.toUrlEncodedRequestBody(bizParams));
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction(request_, runtime_);
                Map<String, Object> respMap = this._kernel.readAsJson(response_, "alipay.trade.refund");
                if (this._kernel.isCertMode() != false ? this._kernel.verify(respMap, this._kernel.extractAlipayPublicKey(this._kernel.getAlipayCertSN(respMap))) != false : this._kernel.verify(respMap, this._kernel.getConfig("alipayPublicKey")) != false) {
                    return TeaModel.toModel(this._kernel.toRespModel(respMap), new AlipayTradeRefundResponse());
                }
                throw new TeaException(TeaConverter.buildMap(new TeaPair("message", "\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u652f\u4ed8\u5b9d\u516c\u94a5\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002")));
            }
            catch (Exception e) {
                if (Tea.isRetryable(e)) continue;
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest);
    }

    public AlipayTradeCloseResponse close(String outTradeNo) throws Exception {
        Map<String, Object> runtime_ = TeaConverter.buildMap(new TeaPair("connectTimeout", 15000), new TeaPair("readTimeout", 15000), new TeaPair("retry", TeaConverter.buildMap(new TeaPair("maxAttempts", 0))));
        TeaRequest _lastRequest = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)runtime_.get("retry"), _retryTimes, _now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), _retryTimes)) > 0) {
                Tea.sleep(backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                Map<String, String> systemParams = TeaConverter.buildMap(new TeaPair("method", "alipay.trade.close"), new TeaPair("app_id", this._kernel.getConfig("appId")), new TeaPair("timestamp", this._kernel.getTimestamp()), new TeaPair("format", "json"), new TeaPair("version", "1.0"), new TeaPair("alipay_sdk", this._kernel.getSdkVersion()), new TeaPair("charset", "UTF-8"), new TeaPair("sign_type", this._kernel.getConfig("signType")), new TeaPair("app_cert_sn", this._kernel.getMerchantCertSN()), new TeaPair("alipay_root_cert_sn", this._kernel.getAlipayRootCertSN()));
                Map bizParams = TeaConverter.buildMap(new TeaPair("out_trade_no", outTradeNo));
                HashMap<String, String> textParams = new HashMap<String, String>();
                request_.protocol = this._kernel.getConfig("protocol");
                request_.method = "POST";
                request_.pathname = "/gateway.do";
                request_.headers = TeaConverter.buildMap(new TeaPair("host", this._kernel.getConfig("gatewayHost")), new TeaPair("content-type", "application/x-www-form-urlencoded;charset=utf-8"));
                request_.query = this._kernel.sortMap(TeaConverter.merge(String.class, TeaConverter.buildMap(new TeaPair("sign", this._kernel.sign(systemParams, bizParams, textParams, this._kernel.getConfig("merchantPrivateKey")))), systemParams, textParams));
                request_.body = Tea.toReadable(this._kernel.toUrlEncodedRequestBody(bizParams));
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction(request_, runtime_);
                Map<String, Object> respMap = this._kernel.readAsJson(response_, "alipay.trade.close");
                if (this._kernel.isCertMode() != false ? this._kernel.verify(respMap, this._kernel.extractAlipayPublicKey(this._kernel.getAlipayCertSN(respMap))) != false : this._kernel.verify(respMap, this._kernel.getConfig("alipayPublicKey")) != false) {
                    return TeaModel.toModel(this._kernel.toRespModel(respMap), new AlipayTradeCloseResponse());
                }
                throw new TeaException(TeaConverter.buildMap(new TeaPair("message", "\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u652f\u4ed8\u5b9d\u516c\u94a5\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002")));
            }
            catch (Exception e) {
                if (Tea.isRetryable(e)) continue;
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest);
    }

    public AlipayTradeCancelResponse cancel(String outTradeNo) throws Exception {
        Map<String, Object> runtime_ = TeaConverter.buildMap(new TeaPair("connectTimeout", 15000), new TeaPair("readTimeout", 15000), new TeaPair("retry", TeaConverter.buildMap(new TeaPair("maxAttempts", 0))));
        TeaRequest _lastRequest = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)runtime_.get("retry"), _retryTimes, _now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), _retryTimes)) > 0) {
                Tea.sleep(backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                Map<String, String> systemParams = TeaConverter.buildMap(new TeaPair("method", "alipay.trade.cancel"), new TeaPair("app_id", this._kernel.getConfig("appId")), new TeaPair("timestamp", this._kernel.getTimestamp()), new TeaPair("format", "json"), new TeaPair("version", "1.0"), new TeaPair("alipay_sdk", this._kernel.getSdkVersion()), new TeaPair("charset", "UTF-8"), new TeaPair("sign_type", this._kernel.getConfig("signType")), new TeaPair("app_cert_sn", this._kernel.getMerchantCertSN()), new TeaPair("alipay_root_cert_sn", this._kernel.getAlipayRootCertSN()));
                Map bizParams = TeaConverter.buildMap(new TeaPair("out_trade_no", outTradeNo));
                HashMap<String, String> textParams = new HashMap<String, String>();
                request_.protocol = this._kernel.getConfig("protocol");
                request_.method = "POST";
                request_.pathname = "/gateway.do";
                request_.headers = TeaConverter.buildMap(new TeaPair("host", this._kernel.getConfig("gatewayHost")), new TeaPair("content-type", "application/x-www-form-urlencoded;charset=utf-8"));
                request_.query = this._kernel.sortMap(TeaConverter.merge(String.class, TeaConverter.buildMap(new TeaPair("sign", this._kernel.sign(systemParams, bizParams, textParams, this._kernel.getConfig("merchantPrivateKey")))), systemParams, textParams));
                request_.body = Tea.toReadable(this._kernel.toUrlEncodedRequestBody(bizParams));
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction(request_, runtime_);
                Map<String, Object> respMap = this._kernel.readAsJson(response_, "alipay.trade.cancel");
                if (this._kernel.isCertMode() != false ? this._kernel.verify(respMap, this._kernel.extractAlipayPublicKey(this._kernel.getAlipayCertSN(respMap))) != false : this._kernel.verify(respMap, this._kernel.getConfig("alipayPublicKey")) != false) {
                    return TeaModel.toModel(this._kernel.toRespModel(respMap), new AlipayTradeCancelResponse());
                }
                throw new TeaException(TeaConverter.buildMap(new TeaPair("message", "\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u652f\u4ed8\u5b9d\u516c\u94a5\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002")));
            }
            catch (Exception e) {
                if (Tea.isRetryable(e)) continue;
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest);
    }

    public AlipayTradeFastpayRefundQueryResponse queryRefund(String outTradeNo, String outRequestNo) throws Exception {
        Map<String, Object> runtime_ = TeaConverter.buildMap(new TeaPair("connectTimeout", 15000), new TeaPair("readTimeout", 15000), new TeaPair("retry", TeaConverter.buildMap(new TeaPair("maxAttempts", 0))));
        TeaRequest _lastRequest = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)runtime_.get("retry"), _retryTimes, _now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), _retryTimes)) > 0) {
                Tea.sleep(backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                Map<String, String> systemParams = TeaConverter.buildMap(new TeaPair("method", "alipay.trade.fastpay.refund.query"), new TeaPair("app_id", this._kernel.getConfig("appId")), new TeaPair("timestamp", this._kernel.getTimestamp()), new TeaPair("format", "json"), new TeaPair("version", "1.0"), new TeaPair("alipay_sdk", this._kernel.getSdkVersion()), new TeaPair("charset", "UTF-8"), new TeaPair("sign_type", this._kernel.getConfig("signType")), new TeaPair("app_cert_sn", this._kernel.getMerchantCertSN()), new TeaPair("alipay_root_cert_sn", this._kernel.getAlipayRootCertSN()));
                Map bizParams = TeaConverter.buildMap(new TeaPair("out_trade_no", outTradeNo), new TeaPair("out_request_no", outRequestNo));
                HashMap<String, String> textParams = new HashMap<String, String>();
                request_.protocol = this._kernel.getConfig("protocol");
                request_.method = "POST";
                request_.pathname = "/gateway.do";
                request_.headers = TeaConverter.buildMap(new TeaPair("host", this._kernel.getConfig("gatewayHost")), new TeaPair("content-type", "application/x-www-form-urlencoded;charset=utf-8"));
                request_.query = this._kernel.sortMap(TeaConverter.merge(String.class, TeaConverter.buildMap(new TeaPair("sign", this._kernel.sign(systemParams, bizParams, textParams, this._kernel.getConfig("merchantPrivateKey")))), systemParams, textParams));
                request_.body = Tea.toReadable(this._kernel.toUrlEncodedRequestBody(bizParams));
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction(request_, runtime_);
                Map<String, Object> respMap = this._kernel.readAsJson(response_, "alipay.trade.fastpay.refund.query");
                if (this._kernel.isCertMode() != false ? this._kernel.verify(respMap, this._kernel.extractAlipayPublicKey(this._kernel.getAlipayCertSN(respMap))) != false : this._kernel.verify(respMap, this._kernel.getConfig("alipayPublicKey")) != false) {
                    return TeaModel.toModel(this._kernel.toRespModel(respMap), new AlipayTradeFastpayRefundQueryResponse());
                }
                throw new TeaException(TeaConverter.buildMap(new TeaPair("message", "\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u652f\u4ed8\u5b9d\u516c\u94a5\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002")));
            }
            catch (Exception e) {
                if (Tea.isRetryable(e)) continue;
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest);
    }

    public AlipayDataDataserviceBillDownloadurlQueryResponse downloadBill(String billType, String billDate) throws Exception {
        Map<String, Object> runtime_ = TeaConverter.buildMap(new TeaPair("connectTimeout", 15000), new TeaPair("readTimeout", 15000), new TeaPair("retry", TeaConverter.buildMap(new TeaPair("maxAttempts", 0))));
        TeaRequest _lastRequest = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)runtime_.get("retry"), _retryTimes, _now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), _retryTimes)) > 0) {
                Tea.sleep(backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                Map<String, String> systemParams = TeaConverter.buildMap(new TeaPair("method", "alipay.data.dataservice.bill.downloadurl.query"), new TeaPair("app_id", this._kernel.getConfig("appId")), new TeaPair("timestamp", this._kernel.getTimestamp()), new TeaPair("format", "json"), new TeaPair("version", "1.0"), new TeaPair("alipay_sdk", this._kernel.getSdkVersion()), new TeaPair("charset", "UTF-8"), new TeaPair("sign_type", this._kernel.getConfig("signType")), new TeaPair("app_cert_sn", this._kernel.getMerchantCertSN()), new TeaPair("alipay_root_cert_sn", this._kernel.getAlipayRootCertSN()));
                Map bizParams = TeaConverter.buildMap(new TeaPair("bill_type", billType), new TeaPair("bill_date", billDate));
                HashMap<String, String> textParams = new HashMap<String, String>();
                request_.protocol = this._kernel.getConfig("protocol");
                request_.method = "POST";
                request_.pathname = "/gateway.do";
                request_.headers = TeaConverter.buildMap(new TeaPair("host", this._kernel.getConfig("gatewayHost")), new TeaPair("content-type", "application/x-www-form-urlencoded;charset=utf-8"));
                request_.query = this._kernel.sortMap(TeaConverter.merge(String.class, TeaConverter.buildMap(new TeaPair("sign", this._kernel.sign(systemParams, bizParams, textParams, this._kernel.getConfig("merchantPrivateKey")))), systemParams, textParams));
                request_.body = Tea.toReadable(this._kernel.toUrlEncodedRequestBody(bizParams));
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction(request_, runtime_);
                Map<String, Object> respMap = this._kernel.readAsJson(response_, "alipay.data.dataservice.bill.downloadurl.query");
                if (this._kernel.isCertMode() != false ? this._kernel.verify(respMap, this._kernel.extractAlipayPublicKey(this._kernel.getAlipayCertSN(respMap))) != false : this._kernel.verify(respMap, this._kernel.getConfig("alipayPublicKey")) != false) {
                    return TeaModel.toModel(this._kernel.toRespModel(respMap), new AlipayDataDataserviceBillDownloadurlQueryResponse());
                }
                throw new TeaException(TeaConverter.buildMap(new TeaPair("message", "\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u652f\u4ed8\u5b9d\u516c\u94a5\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002")));
            }
            catch (Exception e) {
                if (Tea.isRetryable(e)) continue;
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest);
    }

    public Boolean verifyNotify(Map<String, String> parameters) throws Exception {
        if (this._kernel.isCertMode().booleanValue()) {
            return this._kernel.verifyParams(parameters, this._kernel.extractAlipayPublicKey(""));
        }
        return this._kernel.verifyParams(parameters, this._kernel.getConfig("alipayPublicKey"));
    }

    public Client agent(String appAuthToken) {
        this._kernel.injectTextParam("app_auth_token", appAuthToken);
        return this;
    }

    public Client auth(String authToken) {
        this._kernel.injectTextParam("auth_token", authToken);
        return this;
    }

    public Client asyncNotify(String url) {
        this._kernel.injectTextParam("notify_url", url);
        return this;
    }

    public Client route(String testUrl) {
        this._kernel.injectTextParam("ws_service_url", testUrl);
        return this;
    }

    public Client optional(String key, Object value) {
        this._kernel.injectBizParam(key, value);
        return this;
    }

    public Client batchOptional(Map<String, Object> optionalArgs) {
        for (Map.Entry<String, Object> pair : optionalArgs.entrySet()) {
            this._kernel.injectBizParam(pair.getKey(), pair.getValue());
        }
        return this;
    }
}

