/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.easysdk.payment.wap;

import com.alipay.easysdk.payment.wap.models.AlipayTradeWapPayResponse;
import com.aliyun.tea.TeaConverter;
import com.aliyun.tea.TeaModel;
import com.aliyun.tea.TeaPair;
import java.util.Map;

public class Client {
    public com.alipay.easysdk.kernel.Client _kernel;

    public Client(com.alipay.easysdk.kernel.Client kernel) throws Exception {
        this._kernel = kernel;
    }

    public AlipayTradeWapPayResponse pay(String subject, String outTradeNo, String totalAmount, String quitUrl, String returnUrl) throws Exception {
        Map<String, String> systemParams = TeaConverter.buildMap(new TeaPair("method", "alipay.trade.wap.pay"), new TeaPair("app_id", this._kernel.getConfig("appId")), new TeaPair("timestamp", this._kernel.getTimestamp()), new TeaPair("format", "json"), new TeaPair("version", "1.0"), new TeaPair("alipay_sdk", this._kernel.getSdkVersion()), new TeaPair("charset", "UTF-8"), new TeaPair("sign_type", this._kernel.getConfig("signType")), new TeaPair("app_cert_sn", this._kernel.getMerchantCertSN()), new TeaPair("alipay_root_cert_sn", this._kernel.getAlipayRootCertSN()));
        Map bizParams = TeaConverter.buildMap(new TeaPair("subject", subject), new TeaPair("out_trade_no", outTradeNo), new TeaPair("total_amount", totalAmount), new TeaPair("quit_url", quitUrl), new TeaPair("product_code", "QUICK_WAP_WAY"));
        Map<String, String> textParams = TeaConverter.buildMap(new TeaPair("return_url", returnUrl));
        String sign = this._kernel.sign(systemParams, bizParams, textParams, this._kernel.getConfig("merchantPrivateKey"));
        Map response = TeaConverter.buildMap(new TeaPair("body", this._kernel.generatePage("POST", systemParams, bizParams, textParams, sign)));
        return TeaModel.toModel(response, new AlipayTradeWapPayResponse());
    }

    public Client agent(String appAuthToken) {
        this._kernel.injectTextParam("app_auth_token", appAuthToken);
        return this;
    }

    public Client auth(String authToken) {
        this._kernel.injectTextParam("auth_token", authToken);
        return this;
    }

    public Client asyncNotify(String url) {
        this._kernel.injectTextParam("notify_url", url);
        return this;
    }

    public Client route(String testUrl) {
        this._kernel.injectTextParam("ws_service_url", testUrl);
        return this;
    }

    public Client optional(String key, Object value) {
        this._kernel.injectBizParam(key, value);
        return this;
    }

    public Client batchOptional(Map<String, Object> optionalArgs) {
        for (Map.Entry<String, Object> pair : optionalArgs.entrySet()) {
            this._kernel.injectBizParam(pair.getKey(), pair.getValue());
        }
        return this;
    }
}

