package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 门店信息
 *
 * @author auto create
 * @since 1.0, 2020-06-20 11:00:22
 */
public class OrderShopInfo extends AlipayObject {

	private static final long serialVersionUID = 6236582617884142568L;

	/**
	 * 店铺地址
	 */
	@ApiField("address")
	private String address;

	/**
	 * 商户门店id
支持英文、数字的组合
	 */
	@ApiField("merchant_shop_id")
	private String merchantShopId;

	/**
	 * 店铺详情链接地址
	 */
	@ApiField("merchant_shop_link_page")
	private String merchantShopLinkPage;

	/**
	 * 店铺名称
	 */
	@ApiField("name")
	private String name;

	/**
	 * 联系电话-支持固话或手机号
仅支持数字、+、-
	 */
	@ApiField("phone_num")
	private String phoneNum;

	public String getAddress() {
		return this.address;
	}
	public void setAddress(String address) {
		this.address = address;
	}

	public String getMerchantShopId() {
		return this.merchantShopId;
	}
	public void setMerchantShopId(String merchantShopId) {
		this.merchantShopId = merchantShopId;
	}

	public String getMerchantShopLinkPage() {
		return this.merchantShopLinkPage;
	}
	public void setMerchantShopLinkPage(String merchantShopLinkPage) {
		this.merchantShopLinkPage = merchantShopLinkPage;
	}

	public String getName() {
		return this.name;
	}
	public void setName(String name) {
		this.name = name;
	}

	public String getPhoneNum() {
		return this.phoneNum;
	}
	public void setPhoneNum(String phoneNum) {
		this.phoneNum = phoneNum;
	}

}
