/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client.aft.impl;

import com.alipay.sofa.rpc.client.aft.FaultToleranceConfigManager;
import com.alipay.sofa.rpc.client.aft.InvocationStat;
import com.alipay.sofa.rpc.client.aft.InvocationStatDimension;
import com.alipay.sofa.rpc.client.aft.InvocationStatFactory;
import com.alipay.sofa.rpc.client.aft.MeasureModel;
import com.alipay.sofa.rpc.client.aft.MeasureResult;
import com.alipay.sofa.rpc.client.aft.MeasureResultDetail;
import com.alipay.sofa.rpc.client.aft.MeasureState;
import com.alipay.sofa.rpc.client.aft.MeasureStrategy;
import com.alipay.sofa.rpc.client.aft.ProviderInfoWeightManager;
import com.alipay.sofa.rpc.common.utils.CalculateUtils;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@Extension(value="serviceHorizontal")
public class ServiceHorizontalMeasureStrategy
implements MeasureStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceHorizontalMeasureStrategy.class);
    private static final long LEGAL_LEAST_WINDOW_COUNT = 1L;
    protected final ConcurrentMap<String, MeasureModel> appServiceMeasureModels = new ConcurrentHashMap<String, MeasureModel>();

    @Override
    public MeasureResult measure(MeasureModel measureModel) {
        MeasureResult measureResult = new MeasureResult();
        measureResult.setMeasureModel(measureModel);
        String appName = measureModel.getAppName();
        List<InvocationStat> stats = measureModel.getInvocationStats();
        if (!CommonUtils.isNotEmpty(stats)) {
            return measureResult;
        }
        List<InvocationStat> invocationStats = ServiceHorizontalMeasureStrategy.getInvocationStatSnapshots(stats);
        long timeWindow = FaultToleranceConfigManager.getTimeWindow(appName);
        long leastWindowCount = FaultToleranceConfigManager.getLeastWindowCount(appName);
        leastWindowCount = leastWindowCount < 1L ? 1L : leastWindowCount;
        double averageExceptionRate = this.calculateAverageExceptionRate(invocationStats, leastWindowCount);
        double leastWindowExceptionRateMultiple = FaultToleranceConfigManager.getLeastWindowExceptionRateMultiple(appName);
        for (InvocationStat invocationStat : invocationStats) {
            MeasureResultDetail measureResultDetail = null;
            InvocationStatDimension statDimension = invocationStat.getDimension();
            long windowCount = invocationStat.getInvokeCount();
            long invocationLeastWindowCount = this.getInvocationLeastWindowCount(invocationStat, ProviderInfoWeightManager.getWeight(statDimension.getProviderInfo()), leastWindowCount);
            if (averageExceptionRate == -1.0) {
                measureResultDetail = new MeasureResultDetail(statDimension, MeasureState.IGNORE);
            } else if (invocationLeastWindowCount != -1L && windowCount >= invocationLeastWindowCount) {
                double windowExceptionRateMultiple;
                double windowExceptionRate = invocationStat.getExceptionRate();
                measureResultDetail = averageExceptionRate == 0.0 ? new MeasureResultDetail(statDimension, MeasureState.HEALTH) : ((windowExceptionRateMultiple = CalculateUtils.divide(windowExceptionRate, averageExceptionRate)) >= leastWindowExceptionRateMultiple ? new MeasureResultDetail(statDimension, MeasureState.ABNORMAL) : new MeasureResultDetail(statDimension, MeasureState.HEALTH));
                measureResultDetail.setAbnormalRate(windowExceptionRate);
                measureResultDetail.setAverageAbnormalRate(averageExceptionRate);
                measureResultDetail.setLeastAbnormalRateMultiple(leastWindowExceptionRateMultiple);
            } else {
                measureResultDetail = new MeasureResultDetail(statDimension, MeasureState.IGNORE);
            }
            measureResultDetail.setWindowCount(windowCount);
            measureResultDetail.setTimeWindow(timeWindow);
            measureResultDetail.setLeastWindowCount(invocationLeastWindowCount);
            measureResult.addMeasureDetail(measureResultDetail);
        }
        this.logMeasureResult(measureResult, timeWindow, leastWindowCount, averageExceptionRate, leastWindowExceptionRateMultiple);
        InvocationStatFactory.updateInvocationStats(invocationStats);
        return measureResult;
    }

    private void logMeasureResult(MeasureResult measureResult, long timeWindow, long leastWindowCount, double averageExceptionRate, double leastWindowExceptionRateMultiple) {
        if (measureResult == null) {
            return;
        }
        MeasureModel measureModel = measureResult.getMeasureModel();
        String appName = measureModel.getAppName();
        if (!LOGGER.isDebugEnabled(appName)) {
            return;
        }
        String service = measureModel.getService();
        List<InvocationStat> stats = measureModel.getInvocationStats();
        List<MeasureResultDetail> details = measureResult.getAllMeasureResultDetails();
        StringBuilder info = new StringBuilder();
        info.append("measure info: service[" + service + "];stats{");
        for (InvocationStat stat : stats) {
            info.append(stat.getDimension().getIp());
            info.append(",");
        }
        if (stats.size() > 0) {
            info.deleteCharAt(info.length() - 1);
        }
        info.append("};details{");
        info.append("timeWindow[" + timeWindow + "];leastWindowCount[" + leastWindowCount + "];averageExceptionRate[" + averageExceptionRate + "];leastWindowExceptionRateMultiple[" + leastWindowExceptionRateMultiple + "];");
        info.append("detail[");
        for (MeasureResultDetail detail : details) {
            String ip = detail.getInvocationStatDimension().getIp();
            double abnormalRate = detail.getAbnormalRate();
            long invocationLeastWindowCount = detail.getLeastWindowCount();
            String measureState = detail.getMeasureState().name();
            info.append("(ip:" + ip + ",abnormalRate:" + abnormalRate + ",invocationLeastWindowCount:" + invocationLeastWindowCount + ",measureState:" + measureState + ")");
        }
        info.append("]");
        LOGGER.debugWithApp(appName, info.toString());
    }

    public static List<InvocationStat> getInvocationStatSnapshots(List<InvocationStat> stats) {
        ArrayList<InvocationStat> snapshots = new ArrayList<InvocationStat>(stats.size());
        for (InvocationStat stat : stats) {
            InvocationStat snapshot = stat.snapshot();
            if (snapshot.getInvokeCount() <= 0L) {
                if (stat.getUselessCycle().incrementAndGet() <= 6) continue;
                InvocationStatFactory.removeInvocationStat(stat);
                InvocationStatDimension dimension = stat.getDimension();
                String appName = dimension.getAppName();
                if (!LOGGER.isDebugEnabled(appName)) continue;
                LOGGER.debugWithApp(appName, "Remove invocation stat : {}, {} because of useless cycle > 6", dimension.getDimensionKey(), dimension.getProviderInfo());
                continue;
            }
            stat.getUselessCycle().set(0);
            snapshots.add(snapshot);
        }
        return snapshots;
    }

    @Override
    public MeasureModel buildMeasureModel(InvocationStat invocationStat) {
        InvocationStatDimension statDimension = invocationStat.getDimension();
        String key = statDimension.getDimensionKey();
        MeasureModel measureModel = (MeasureModel)this.appServiceMeasureModels.get(key);
        if (measureModel == null) {
            measureModel = new MeasureModel(statDimension.getAppName(), statDimension.getService());
            MeasureModel oldMeasureModel = this.appServiceMeasureModels.putIfAbsent(key, measureModel);
            if (oldMeasureModel == null) {
                measureModel.addInvocationStat(invocationStat);
                return measureModel;
            }
            oldMeasureModel.addInvocationStat(invocationStat);
            return null;
        }
        measureModel.addInvocationStat(invocationStat);
        return null;
    }

    @Override
    public MeasureModel removeMeasureModel(InvocationStat invocationStat) {
        InvocationStatDimension statDimension = invocationStat.getDimension();
        MeasureModel measureModel = (MeasureModel)this.appServiceMeasureModels.get(statDimension.getDimensionKey());
        if (measureModel != null) {
            measureModel.removeInvocationStat(invocationStat);
        }
        return measureModel;
    }

    private double calculateAverageExceptionRate(List<InvocationStat> invocationStats, long leastWindowCount) {
        long sumException = 0L;
        long sumCall = 0L;
        for (InvocationStat invocationStat : invocationStats) {
            long invocationLeastWindowCount = this.getInvocationLeastWindowCount(invocationStat, ProviderInfoWeightManager.getWeight(invocationStat.getDimension().getProviderInfo()), leastWindowCount);
            if (invocationLeastWindowCount == -1L || invocationStat.getInvokeCount() < invocationLeastWindowCount) continue;
            sumException += invocationStat.getExceptionCount();
            sumCall += invocationStat.getInvokeCount();
        }
        if (sumCall == 0L) {
            return -1.0;
        }
        return CalculateUtils.divide(sumException, sumCall);
    }

    private long getInvocationLeastWindowCount(InvocationStat invocationStat, Integer weight, long leastWindowCount) {
        InvocationStatDimension statDimension = invocationStat.getDimension();
        Integer originWeight = statDimension.getOriginWeight();
        if (originWeight == 0) {
            LOGGER.errorWithApp(statDimension.getAppName(), "originWeight is 0,but is invoked. service[" + statDimension.getService() + "];ip[" + statDimension.getIp() + "].");
            return -1L;
        }
        if (weight == null) {
            return leastWindowCount;
        }
        if (weight == -1) {
            return -1L;
        }
        double rate = CalculateUtils.divide(weight.intValue(), originWeight.intValue());
        long invocationLeastWindowCount = CalculateUtils.multiply(leastWindowCount, rate);
        return invocationLeastWindowCount < 1L ? 1L : invocationLeastWindowCount;
    }
}

