package com.dingtalk.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;
import java.util.List;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.dingtalk.api.DingTalkConstants;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.TaobaoUtils;

import com.dingtalk.api.response.CorpHrmEmployeeDelresumerecordResponse;

/**
 * TOP DingTalk-API: dingtalk.corp.hrm.employee.delresumerecord request
 * 
 * @author top auto create
 * @since 1.0, 2018.05.25
 */
public class CorpHrmEmployeeDelresumerecordRequest extends BaseTaobaoRequest<CorpHrmEmployeeDelresumerecordResponse> {
	
	

	/** 
	* 成长记录唯一标识
	 */
	private String resumeId;

	/** 
	* 员工userid
	 */
	private String userid;

	public void setResumeId(String resumeId) {
		this.resumeId = resumeId;
	}

	public String getResumeId() {
		return this.resumeId;
	}

	public void setUserid(String userid) {
		this.userid = userid;
	}

	public String getUserid() {
		return this.userid;
	}

	public String getApiMethodName() {
		return "dingtalk.corp.hrm.employee.delresumerecord";
	}

	private String topResponseType = Constants.RESPONSE_TYPE_DINGTALK_OAPI;

     public String getTopResponseType() {
        return this.topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

     public String getTopApiCallType() {
        return DingTalkConstants.CALL_TYPE_TOP;
     }

     private String topHttpMethod = DingTalkConstants.HTTP_METHOD_POST;

     public String getTopHttpMethod() {
     	return this.topHttpMethod;
     }

     public void setTopHttpMethod(String topHttpMethod) {
        this.topHttpMethod = topHttpMethod;
     }

     public void setHttpMethod(String httpMethod) {
         this.setTopHttpMethod(httpMethod);
     }

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("resume_id", this.resumeId);
		txtParams.put("userid", this.userid);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<CorpHrmEmployeeDelresumerecordResponse> getResponseClass() {
		return CorpHrmEmployeeDelresumerecordResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(resumeId, "resumeId");
		RequestCheckUtils.checkNotEmpty(userid, "userid");
	}
	

}