package com.dingtalk.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;
import java.util.List;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.dingtalk.api.DingTalkConstants;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.TaobaoUtils;

import com.dingtalk.api.response.OapiOpenencryptHeartbeatResponse;

/**
 * TOP DingTalk-API: dingtalk.oapi.openencrypt.heartbeat request
 * 
 * @author top auto create
 * @since 1.0, 2019.09.23
 */
public class OapiOpenencryptHeartbeatRequest extends BaseTaobaoRequest<OapiOpenencryptHeartbeatResponse> {
	
	

	/** 
	* 微应用id
	 */
	private Long appid;

	/** 
	* xxx
	 */
	private String extension;

	public void setAppid(Long appid) {
		this.appid = appid;
	}

	public Long getAppid() {
		return this.appid;
	}

	public void setExtension(String extension) {
		this.extension = extension;
	}

	public String getExtension() {
		return this.extension;
	}

	public String getApiMethodName() {
		return "dingtalk.oapi.openencrypt.heartbeat";
	}

	private String topResponseType = Constants.RESPONSE_TYPE_DINGTALK_OAPI;

     public String getTopResponseType() {
        return this.topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

     public String getTopApiCallType() {
        return DingTalkConstants.CALL_TYPE_OAPI;
     }

     private String topHttpMethod = DingTalkConstants.HTTP_METHOD_POST;

     public String getTopHttpMethod() {
     	return this.topHttpMethod;
     }

     public void setTopHttpMethod(String topHttpMethod) {
        this.topHttpMethod = topHttpMethod;
     }

     public void setHttpMethod(String httpMethod) {
         this.setTopHttpMethod(httpMethod);
     }

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("appid", this.appid);
		txtParams.put("extension", this.extension);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<OapiOpenencryptHeartbeatResponse> getResponseClass() {
		return OapiOpenencryptHeartbeatResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(appid, "appid");
	}
	

}