/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyuncs.cdn.transform.v20180510;

import java.util.ArrayList;
import java.util.List;

import com.aliyuncs.cdn.model.v20180510.ListRealtimeLogDeliveryDomainsResponse;
import com.aliyuncs.cdn.model.v20180510.ListRealtimeLogDeliveryDomainsResponse.Domains;
import com.aliyuncs.transform.UnmarshallerContext;


public class ListRealtimeLogDeliveryDomainsResponseUnmarshaller {

	public static ListRealtimeLogDeliveryDomainsResponse unmarshall(ListRealtimeLogDeliveryDomainsResponse listRealtimeLogDeliveryDomainsResponse, UnmarshallerContext _ctx) {
		
		listRealtimeLogDeliveryDomainsResponse.setRequestId(_ctx.stringValue("ListRealtimeLogDeliveryDomainsResponse.RequestId"));

		List<Domains> content = new ArrayList<Domains>();
		for (int i = 0; i < _ctx.lengthValue("ListRealtimeLogDeliveryDomainsResponse.Content.Length"); i++) {
			Domains domains = new Domains();
			domains.setDomainName(_ctx.stringValue("ListRealtimeLogDeliveryDomainsResponse.Content["+ i +"].DomainName"));
			domains.setStatus(_ctx.stringValue("ListRealtimeLogDeliveryDomainsResponse.Content["+ i +"].Status"));

			content.add(domains);
		}
		listRealtimeLogDeliveryDomainsResponse.setContent(content);
	 
	 	return listRealtimeLogDeliveryDomainsResponse;
	}
}