/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyuncs.cms.transform.v20190101;

import com.aliyuncs.cms.model.v20190101.CreateHostAvailabilityResponse;
import com.aliyuncs.transform.UnmarshallerContext;


public class CreateHostAvailabilityResponseUnmarshaller {

	public static CreateHostAvailabilityResponse unmarshall(CreateHostAvailabilityResponse createHostAvailabilityResponse, UnmarshallerContext context) {
		
		createHostAvailabilityResponse.setRequestId(context.stringValue("CreateHostAvailabilityResponse.RequestId"));
		createHostAvailabilityResponse.setCode(context.stringValue("CreateHostAvailabilityResponse.Code"));
		createHostAvailabilityResponse.setMessage(context.stringValue("CreateHostAvailabilityResponse.Message"));
		createHostAvailabilityResponse.setSuccess(context.booleanValue("CreateHostAvailabilityResponse.Success"));
		createHostAvailabilityResponse.setTaskId(context.longValue("CreateHostAvailabilityResponse.TaskId"));
	 
	 	return createHostAvailabilityResponse;
	}
}