/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyuncs.edas.model.v20170801;

import com.aliyuncs.RoaAcsRequest;
import com.aliyuncs.http.MethodType;

/**
 * @author auto create
 * @version 
 */
public class QueryMigrateEcuListRequest extends RoaAcsRequest<QueryMigrateEcuListResponse> {
	
	public QueryMigrateEcuListRequest() {
		super("Edas", "2017-08-01", "QueryMigrateEcuList");
		setUriPattern("/pop/v5/resource/migrate_ecu_list");
		setMethod(MethodType.GET);
	}

	private String logicalRegionId;

	public String getLogicalRegionId() {
		return this.logicalRegionId;
	}

	public void setLogicalRegionId(String logicalRegionId) {
		this.logicalRegionId = logicalRegionId;
		if(logicalRegionId != null){
			putQueryParameter("LogicalRegionId", logicalRegionId);
		}
	}

	@Override
	public Class<QueryMigrateEcuListResponse> getResponseClass() {
		return QueryMigrateEcuListResponse.class;
	}

}
