/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyuncs.slb.model.v20140515;

import java.util.List;
import com.aliyuncs.AcsResponse;
import com.aliyuncs.slb.transform.v20140515.DescribeAvailableResourceResponseUnmarshaller;
import com.aliyuncs.transform.UnmarshallerContext;

/**
 * @author auto create
 * @version 
 */
public class DescribeAvailableResourceResponse extends AcsResponse {

	private String requestId;

	private List<AvailableResource> availableResources;

	public String getRequestId() {
		return this.requestId;
	}

	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	public List<AvailableResource> getAvailableResources() {
		return this.availableResources;
	}

	public void setAvailableResources(List<AvailableResource> availableResources) {
		this.availableResources = availableResources;
	}

	public static class AvailableResource {

		private String masterZoneId;

		private String slaveZoneId;

		private List<SupportResource> supportResources;

		public String getMasterZoneId() {
			return this.masterZoneId;
		}

		public void setMasterZoneId(String masterZoneId) {
			this.masterZoneId = masterZoneId;
		}

		public String getSlaveZoneId() {
			return this.slaveZoneId;
		}

		public void setSlaveZoneId(String slaveZoneId) {
			this.slaveZoneId = slaveZoneId;
		}

		public List<SupportResource> getSupportResources() {
			return this.supportResources;
		}

		public void setSupportResources(List<SupportResource> supportResources) {
			this.supportResources = supportResources;
		}

		public static class SupportResource {

			private String addressType;

			private String addressIPVersion;

			public String getAddressType() {
				return this.addressType;
			}

			public void setAddressType(String addressType) {
				this.addressType = addressType;
			}

			public String getAddressIPVersion() {
				return this.addressIPVersion;
			}

			public void setAddressIPVersion(String addressIPVersion) {
				this.addressIPVersion = addressIPVersion;
			}
		}
	}

	@Override
	public DescribeAvailableResourceResponse getInstance(UnmarshallerContext context) {
		return	DescribeAvailableResourceResponseUnmarshaller.unmarshall(this, context);
	}
}
