/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.credentials;

import com.aliyun.credentials.AccessKeyCredential;
import com.aliyun.credentials.AlibabaCloudCredentials;
import com.aliyun.credentials.BearerTokenCredential;
import com.aliyun.credentials.StsCredential;
import com.aliyun.credentials.exception.CredentialException;
import com.aliyun.credentials.models.Config;
import com.aliyun.credentials.provider.AlibabaCloudCredentialsProvider;
import com.aliyun.credentials.provider.DefaultCredentialsProvider;
import com.aliyun.credentials.provider.EcsRamRoleCredentialProvider;
import com.aliyun.credentials.provider.RamRoleArnCredentialProvider;
import com.aliyun.credentials.provider.RsaKeyPairCredentialProvider;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.ParseException;

public class Client {
    private AlibabaCloudCredentials cloudCredential;

    public Client(Config config) throws ParseException, CredentialException, IOException {
        if (null == config) {
            DefaultCredentialsProvider provider = new DefaultCredentialsProvider();
            this.cloudCredential = provider.getCredentials();
        }
        this.cloudCredential = this.getCredential(config);
    }

    public AlibabaCloudCredentials getCredential(Config config) throws IOException, CredentialException, ParseException {
        switch (config.type) {
            case "access_key": {
                return new AccessKeyCredential(config.accessKeyId, config.accessKeySecret);
            }
            case "sts": {
                return new StsCredential(config.accessKeyId, config.accessKeySecret, config.securityToken);
            }
            case "bearer": {
                return new BearerTokenCredential(config.bearerToken);
            }
        }
        return this.getProvider(config).getCredentials();
    }

    private AlibabaCloudCredentialsProvider getProvider(Config config) throws CredentialException, MalformedURLException {
        try {
            switch (config.type) {
                case "ecs_ram_role": {
                    return new EcsRamRoleCredentialProvider(config);
                }
                case "ram_role_arn": {
                    return new RamRoleArnCredentialProvider(config);
                }
                case "rsa_key_pair": {
                    return new RsaKeyPairCredentialProvider(config);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new DefaultCredentialsProvider();
    }

    public String getAccessKeyId() {
        return this.cloudCredential.getAccessKeyId();
    }

    public String getAccessKeySecret() {
        return this.cloudCredential.getAccessKeySecret();
    }

    public String getSecurityToken() {
        return this.cloudCredential.getSecurityToken();
    }

    public String getType() {
        return this.cloudCredential.getType();
    }

    public String getBearerToken() {
        return this.cloudCredential.getBearerToken();
    }
}

