/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AdvancedScanResultConsumer;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncRegistry;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.AsyncTableBuilder;
import org.apache.hadoop.hbase.client.AsyncTableBuilderBase;
import org.apache.hadoop.hbase.client.AsyncTableImpl;
import org.apache.hadoop.hbase.client.RawAsyncColdTableImpl;
import org.apache.hadoop.hbase.client.RawAsyncHotTableImpl;
import org.apache.hadoop.hbase.client.RawAsyncTableImpl;
import org.apache.hadoop.hbase.client.ScanResultConsumer;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.security.User;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class AsyncLayeredConnectionImpl
extends AsyncConnectionImpl {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncLayeredConnectionImpl.class);

    public AsyncLayeredConnectionImpl(Configuration conf, AsyncRegistry registry, String clusterId, User user) {
        super(conf, registry, clusterId, user);
    }

    @Override
    public AsyncTableBuilder<AdvancedScanResultConsumer> getTableBuilder(TableName tableName) {
        return new AsyncTableBuilderBase<AdvancedScanResultConsumer>(tableName, this.connConf){

            @Override
            public AsyncTable<AdvancedScanResultConsumer> build() {
                return AsyncLayeredConnectionImpl.getRawAsyncTable((AsyncConnectionImpl)AsyncLayeredConnectionImpl.this, this);
            }
        };
    }

    @Override
    public AsyncTableBuilder<ScanResultConsumer> getTableBuilder(TableName tableName, final ExecutorService pool) {
        return new AsyncTableBuilderBase<ScanResultConsumer>(tableName, this.connConf){

            @Override
            public AsyncTable<ScanResultConsumer> build() {
                RawAsyncTableImpl rawTable = AsyncLayeredConnectionImpl.getRawAsyncTable((AsyncConnectionImpl)AsyncLayeredConnectionImpl.this, this);
                return new AsyncTableImpl(AsyncLayeredConnectionImpl.this, rawTable, pool);
            }
        };
    }

    private static RawAsyncTableImpl getRawAsyncTable(AsyncConnectionImpl conn, AsyncTableBuilderBase<?> builder) {
        long hotTtl = -1L;
        if (builder.tableName.isSystemTable()) {
            return new RawAsyncTableImpl(conn, builder);
        }
        AsyncAdmin admin = conn.getAdmin();
        try {
            TableDescriptor descriptor = admin.getDescriptor(builder.tableName).get();
            if (descriptor.getValue(HConstants.SINK_TABLE_NAME) != null) {
                hotTtl = Long.parseLong(descriptor.getValue(HConstants.SOURCE_TTL));
                if (hotTtl > 0L) {
                    return new RawAsyncHotTableImpl(conn, builder, hotTtl);
                }
            } else if (descriptor.getValue(HConstants.SOURCE_TABLE_NAME) != null) {
                TableName hotTable = TableName.valueOf((String)descriptor.getValue(HConstants.SOURCE_TABLE_NAME));
                TableDescriptor hotDescriptor = admin.getDescriptor(hotTable).get();
                if (builder.tableName.toString().equals(hotDescriptor.getValue(HConstants.SINK_TABLE_NAME)) && (hotTtl = Long.parseLong(hotDescriptor.getValue(HConstants.SOURCE_TTL))) > 0L) {
                    return new RawAsyncColdTableImpl(conn, builder, hotTable, hotTtl);
                }
            }
        }
        catch (Exception e) {
            LOG.error("exception caught when getting hot/cold tables", (Throwable)e);
        }
        return new RawAsyncTableImpl(conn, builder);
    }
}

