/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClientUtil;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.LayeredHTable;
import org.apache.hadoop.hbase.client.MergeScanner;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableBuilderBase;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class ColdHTable
extends LayeredHTable {
    protected TableName hotTableName = null;
    protected LayeredHTable hotTable = null;
    protected long hotTtl = -1L;

    @InterfaceAudience.Private
    protected ColdHTable(ClusterConnection connection, TableBuilderBase builder, RpcRetryingCallerFactory rpcCallerFactory, RpcControllerFactory rpcControllerFactory, ExecutorService pool, TableName hotTableName, long hotTtl) {
        super(connection, builder, rpcCallerFactory, rpcControllerFactory, pool);
        this.hotTableName = hotTableName;
        this.hotTtl = hotTtl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LayeredHTable getHotTable() throws IOException {
        if (this.hotTable != null) {
            return this.hotTable;
        }
        if (this.hotTableName == null) {
            return null;
        }
        ColdHTable coldHTable = this;
        synchronized (coldHTable) {
            if (this.hotTable == null) {
                this.hotTable = (LayeredHTable)this.getConnection().getTable(this.hotTableName);
            }
            return this.hotTable;
        }
    }

    @Override
    public ResultScanner getScanner(Scan scan) throws IOException {
        LayeredHTable hot = this.getHotTable();
        Scan hotScan = ClientUtil.makeHotTableScan(scan, this.hotTtl);
        return new MergeScanner(scan, hot.getRawScanner(hotScan), this.getRawScanner(scan));
    }

    @Override
    protected Result get(Get get, boolean checkExistenceOnly) throws IOException {
        LayeredHTable hot = this.getHotTable();
        Get hotGet = ClientUtil.makeHotTableGet(get, this.hotTtl);
        Result hotr = hot.rawGet(hotGet, checkExistenceOnly);
        Result coldr = this.rawGet(get, checkExistenceOnly);
        return MergeScanner.mergeResultsOfSameRow(hotr, coldr, get.getMaxVersions());
    }

    @Override
    public Result[] get(List<Get> gets) throws IOException {
        if (gets.size() == 1) {
            return new Result[]{this.get(gets.get(0))};
        }
        LayeredHTable hot = this.getHotTable();
        List<Get> hotGets = ClientUtil.makeHotTableGets(gets, this.hotTtl);
        Result[] r1 = this.rawGet(gets);
        Result[] r2 = hot.rawGet(hotGets);
        Result[] results = new Result[r1.length];
        for (int i = 0; i < gets.size(); ++i) {
            results[i] = MergeScanner.mergeResultsOfSameRow(r1[i], r2[i], gets.get(i).getMaxVersions());
        }
        return results;
    }
}

