/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColdHTable;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HotHTable;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableBuilder;
import org.apache.hadoop.hbase.client.TableBuilderBase;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.security.User;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class LayeredConnectionImplementation
extends ConnectionImplementation {
    private static final Logger LOG = LoggerFactory.getLogger(LayeredConnectionImplementation.class);

    LayeredConnectionImplementation(Configuration conf, ExecutorService pool, User user) throws IOException {
        super(conf, pool, user);
    }

    @Override
    public TableBuilder getTableBuilder(TableName tableName, final ExecutorService pool) {
        return new TableBuilderBase(tableName, this.getConnectionConfiguration()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Table build() {
                HTable hTable;
                long hotTtl = -1L;
                Admin admin = null;
                try {
                    admin = LayeredConnectionImplementation.this.getAdmin();
                    TableDescriptor descriptor = admin.getDescriptor(this.tableName);
                    if (descriptor.getValue(HConstants.SINK_TABLE_NAME) != null) {
                        hotTtl = Long.parseLong(descriptor.getValue(HConstants.SOURCE_TTL));
                        if (hotTtl > 0L) {
                            HotHTable hotHTable = new HotHTable(LayeredConnectionImplementation.this, this, LayeredConnectionImplementation.this.getRpcRetryingCallerFactory(), LayeredConnectionImplementation.this.getRpcControllerFactory(), pool, hotTtl);
                            return hotHTable;
                        }
                    } else if (descriptor.getValue(HConstants.SOURCE_TABLE_NAME) != null) {
                        TableName hotTableName = TableName.valueOf((String)descriptor.getValue(HConstants.SOURCE_TABLE_NAME));
                        TableDescriptor hotDescriptor = admin.getDescriptor(hotTableName);
                        if (this.tableName.toString().equals(hotDescriptor.getValue(HConstants.SINK_TABLE_NAME)) && (hotTtl = Long.parseLong(hotDescriptor.getValue(HConstants.SOURCE_TTL))) > 0L) {
                            ColdHTable coldHTable = new ColdHTable(LayeredConnectionImplementation.this, this, LayeredConnectionImplementation.this.getRpcRetryingCallerFactory(), LayeredConnectionImplementation.this.getRpcControllerFactory(), pool, hotTableName, hotTtl);
                            return coldHTable;
                        }
                    }
                    hTable = new HTable(LayeredConnectionImplementation.this, this, LayeredConnectionImplementation.this.getRpcRetryingCallerFactory(), LayeredConnectionImplementation.this.getRpcControllerFactory(), pool);
                    return hTable;
                }
                catch (IOException e) {
                    LOG.error("exception caught when getting hot/cold tables", (Throwable)e);
                    hTable = new HTable(LayeredConnectionImplementation.this, this, LayeredConnectionImplementation.this.getRpcRetryingCallerFactory(), LayeredConnectionImplementation.this.getRpcControllerFactory(), pool);
                    return hTable;
                }
                finally {
                    if (admin != null) {
                        try {
                            admin.close();
                        }
                        catch (IOException e) {
                            LOG.error("exception caught when getting hot/cold tables", (Throwable)e);
                        }
                    }
                }
            }
        };
    }
}

