/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client;

import com.aliyun.hitsdb.client.http.HttpClient;
import javafx.util.Pair;

public class HAPolicy {
    private Pair<String, Integer> secondaryCluster;
    private RetryRule retryRule = RetryRule.SecondaryPreferred;
    private int queryRetryTimes = 0;
    private long queryRetryInterval = 0L;

    public static Builder addSecondaryCluster(String secondaryHost, int secondaryPort) {
        return new Builder(secondaryHost, secondaryPort);
    }

    public String getSecondaryHost() {
        return (String)this.secondaryCluster.getKey();
    }

    public int getSecondaryPort() {
        return (Integer)this.secondaryCluster.getValue();
    }

    public RetryRule getRetryRule() {
        return this.retryRule;
    }

    public int getQueryRetryTimes() {
        return this.queryRetryTimes;
    }

    public long getQueryRetryInterval() {
        return this.queryRetryInterval;
    }

    public static class QueryContext {
        private HAPolicy haPolicy;
        private int retryTimes = 0;
        private HttpClient primaryClient;
        private HttpClient secondaryClient;

        public QueryContext(HAPolicy haPolicy, HttpClient primaryClient, HttpClient secondaryClient) {
            this.haPolicy = haPolicy;
            this.primaryClient = primaryClient;
            this.secondaryClient = secondaryClient;
        }

        public boolean doQuery() {
            return this.haPolicy.getRetryRule() == RetryRule.Primary || this.haPolicy.getRetryRule() == RetryRule.Secondary ? this.retryTimes < this.haPolicy.getQueryRetryTimes() : (this.haPolicy.getRetryRule() == RetryRule.PrimaryPreferred || this.haPolicy.getRetryRule() == RetryRule.SecondaryPreferred) && this.retryTimes < this.haPolicy.getQueryRetryTimes() + 1;
        }

        public void addRetryTimes() {
            ++this.retryTimes;
        }

        public HttpClient getClient() {
            switch (this.haPolicy.getRetryRule()) {
                case Primary: {
                    return this.primaryClient;
                }
                case Secondary: {
                    return this.secondaryClient;
                }
                case SecondaryPreferred: {
                    if (this.retryTimes <= this.haPolicy.getQueryRetryTimes()) {
                        return this.secondaryClient;
                    }
                    return this.primaryClient;
                }
                case PrimaryPreferred: {
                    if (this.retryTimes <= this.haPolicy.getQueryRetryTimes()) {
                        return this.primaryClient;
                    }
                    return this.secondaryClient;
                }
            }
            throw new IllegalArgumentException("Unknown Retry Policy");
        }
    }

    public static class Builder {
        private HAPolicy policy = new HAPolicy();

        public Builder(String secondaryHost, int secondaryPort) {
            this.policy.secondaryCluster = new Pair((Object)secondaryHost, (Object)secondaryPort);
        }

        public Builder setRetryRule(RetryRule rule) {
            this.policy.retryRule = rule;
            return this;
        }

        public Builder setRetryTimes(int retryTimes) {
            if (retryTimes < 0) {
                throw new IllegalArgumentException("retryTimes must greater or equal than 0");
            }
            this.policy.queryRetryTimes = retryTimes;
            return this;
        }

        public HAPolicy build() {
            return this.policy;
        }
    }

    public static enum RetryRule {
        Primary,
        Secondary,
        PrimaryPreferred,
        SecondaryPreferred;

    }
}

