/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.callback.http;

import com.aliyun.hitsdb.client.Config;
import com.aliyun.hitsdb.client.callback.AbstractBatchPutCallback;
import com.aliyun.hitsdb.client.callback.AbstractMultiFieldBatchPutCallback;
import com.aliyun.hitsdb.client.callback.QueryCallback;
import com.aliyun.hitsdb.client.callback.http.BaseHttpFutureCallback;
import com.aliyun.hitsdb.client.callback.http.BatchPutHttpResponseCallback;
import com.aliyun.hitsdb.client.callback.http.MultiFieldBatchPutHttpResponseCallback;
import com.aliyun.hitsdb.client.callback.http.QueryHttpResponseCallback;
import com.aliyun.hitsdb.client.http.HttpClient;
import com.aliyun.hitsdb.client.util.Objects;
import com.aliyun.hitsdb.client.value.request.MultiFieldPoint;
import com.aliyun.hitsdb.client.value.request.Point;
import com.aliyun.hitsdb.client.value.request.Query;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;

public class HttpResponseCallbackFactory {
    private final AtomicInteger unCompletedTaskNum;
    private final HttpClient hitsdbHttpclient;
    private final boolean httpCompress;

    public HttpResponseCallbackFactory(AtomicInteger unCompletedTaskNum, HttpClient httpclient, boolean httpCompress) {
        this.unCompletedTaskNum = unCompletedTaskNum;
        this.hitsdbHttpclient = httpclient;
        this.httpCompress = httpCompress;
    }

    public FutureCallback<HttpResponse> wrapUpBaseHttpFutureCallback(FutureCallback<HttpResponse> futureCallback) {
        Objects.requireNonNull(futureCallback);
        return new BaseHttpFutureCallback(this.unCompletedTaskNum, futureCallback);
    }

    public FutureCallback<HttpResponse> createQueryCallback(String address, QueryCallback callback, Query query) {
        QueryHttpResponseCallback httpCallback = new QueryHttpResponseCallback(address, query, callback, this.httpCompress);
        return httpCallback;
    }

    public FutureCallback<HttpResponse> createBatchPutDataCallback(String address, AbstractBatchPutCallback<?> batchPutCallback, List<Point> pointList, Config config, int retryTimes) {
        BatchPutHttpResponseCallback httpCallback = new BatchPutHttpResponseCallback(address, this.hitsdbHttpclient, batchPutCallback, pointList, config, retryTimes);
        return httpCallback;
    }

    public FutureCallback<HttpResponse> createNoLogicBatchPutHttpFutureCallback(String address, List<Point> pointList, Config config, int batchPutRetryTimes) {
        BatchPutHttpResponseCallback httpCallback = new BatchPutHttpResponseCallback(address, this.hitsdbHttpclient, null, pointList, config, batchPutRetryTimes);
        return httpCallback;
    }

    public FutureCallback<HttpResponse> createMultiFieldBatchPutDataCallback(String address, AbstractMultiFieldBatchPutCallback<?> batchPutCallback, List<MultiFieldPoint> pointList, Config config, int retryTimes) {
        MultiFieldBatchPutHttpResponseCallback httpCallback = new MultiFieldBatchPutHttpResponseCallback(address, this.hitsdbHttpclient, batchPutCallback, pointList, config, retryTimes);
        return httpCallback;
    }

    public FutureCallback<HttpResponse> createMultiFieldNoLogicBatchPutHttpFutureCallback(String address, List<MultiFieldPoint> pointList, Config config, int batchPutRetryTimes) {
        MultiFieldBatchPutHttpResponseCallback httpCallback = new MultiFieldBatchPutHttpResponseCallback(address, this.hitsdbHttpclient, null, pointList, config, batchPutRetryTimes);
        return httpCallback;
    }
}

