/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.callback.http;

import com.alibaba.fastjson.JSON;
import com.aliyun.hitsdb.client.TSDBClient;
import com.aliyun.hitsdb.client.callback.QueryCallback;
import com.aliyun.hitsdb.client.exception.http.HttpServerErrorException;
import com.aliyun.hitsdb.client.exception.http.HttpServerNotSupportException;
import com.aliyun.hitsdb.client.exception.http.HttpUnknowStatusException;
import com.aliyun.hitsdb.client.http.response.HttpStatus;
import com.aliyun.hitsdb.client.http.response.ResultResponse;
import com.aliyun.hitsdb.client.value.request.Query;
import com.aliyun.hitsdb.client.value.response.QueryResult;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;

public class QueryHttpResponseCallback
implements FutureCallback<HttpResponse> {
    private final String address;
    private final Query query;
    private final QueryCallback callback;
    private final boolean compress;

    public QueryHttpResponseCallback(String address, Query query, QueryCallback callback, boolean compress) {
        this.address = address;
        this.query = query;
        this.callback = callback;
        this.compress = compress;
    }

    public void completed(HttpResponse httpResponse) {
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.compress);
        HttpStatus httpStatus = resultResponse.getHttpStatus();
        switch (httpStatus) {
            case ServerSuccessNoContent: {
                this.callback.response(this.address, this.query, null);
                return;
            }
            case ServerSuccess: {
                String content = resultResponse.getContent();
                List queryResultList = JSON.parseArray((String)content, QueryResult.class);
                TSDBClient.setTypeIfNeeded(this.query, queryResultList);
                this.callback.response(this.address, this.query, queryResultList);
                return;
            }
            case ServerNotSupport: {
                this.callback.failed(this.address, this.query, new HttpServerNotSupportException(resultResponse));
            }
            case ServerError: {
                this.callback.failed(this.address, this.query, new HttpServerErrorException(resultResponse));
            }
        }
        this.callback.failed(this.address, this.query, new HttpUnknowStatusException(resultResponse));
    }

    public void failed(Exception ex) {
        this.callback.failed(this.address, this.query, ex);
    }

    public void cancelled() {
    }
}

