/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class HttpUtil {
    public static String get(String url) throws IOException {
        return HttpUtil.fetch("GET", url, null, null);
    }

    public static String fetch(String method, String url, String body, Map<String, String> headers) throws IOException {
        URL u = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)u.openConnection();
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        if (method != null) {
            conn.setRequestMethod(method);
        }
        if (headers != null) {
            for (String key : headers.keySet()) {
                conn.addRequestProperty(key, headers.get(key));
            }
        }
        if (body != null) {
            conn.setDoOutput(true);
            OutputStream os = conn.getOutputStream();
            os.write(body.getBytes());
            os.flush();
            os.close();
        }
        InputStream is = conn.getInputStream();
        String response = HttpUtil.streamToString(is);
        is.close();
        if (conn.getResponseCode() == 301) {
            String location = conn.getHeaderField("Location");
            return HttpUtil.fetch(method, location, body, headers);
        }
        return response;
    }

    public static String streamToString(InputStream in) throws IOException {
        int n;
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }
}

